@extends('layouts.production')
@section('addCss')
<style media="screen">
table tr td {
  vertical-align: top !important;
}
.msg-sku { font-size: 10px !important; margin-bottom: 0px; }
</style>
@endsection
@section('content')
<section class="content-header">
  <h1 id="invoice-id" data-id="{{ $invoiceId }}" data-url="{{ route('loadPreOrder', $invoiceId) }}">
    {{ Trans('quotations.menu') }}
    <small>{{ Trans('dashboard.crud.add') }}</small>
  </h1>
  <ol class="breadcrumb">
    <li><a href="/"><i class="fa fa-dashboard"></i> {{ Trans('dashboard.home') }}</a></li>
    <li class="active">{{ Trans('quotations.menu') }}</li>
  </ol>
</section>
<!-- Main content -->
<section class="content qurl" data-list-products="{{ route('products.inStock') }}" data-add-product="{{ route('quotations.orders') }}" data-update-product="{{ route('updatePreOrder') }}" data-delete-product="{{ route("deletePreOrder") }}">
@include('layouts.includes.message')
<div class="row">
    <div class="col-md-5">
    <div class="box">
      <div class="box-header with-border">
        <h3 class="box-title">
          {{ trans('quotations.products_in_stock') }}
        </h3>
        <a href="#" class="btn btn-sm btn-default pull-right" data-toggle="modal" data-target="#newProduct" data-backdrop="static" data-keyboard="false">{{ trans('quotations.new_product') }}</a>
      </div>
      <!-- /.box-header -->
      <div class="box-body">
        <table class="table" id="products-in-stock">
          <thead>
            <tr>
              <th>{{ trans('products.sku') }}</th>
              <th>{{ trans('products.name') }}</th>
              <th>{{ trans('products.amount') }}</th>
              <th style="width: 20%;">{{ trans('products.price') }}</th>
              <th>{{ trans('dashboard.crud.actions') }}</th>
            </tr>
          </thead>
        </table>
      </div>
        <!-- /.box-body -->
    </div>
      <!-- /.box -->
  </div>
  <div class="col-md-7">
    <div class="box">
      <div class="box-header with-border">
        <h3 class="box-title">
          {{ trans('quotations.table_of_products') }}
        </h3>
      </div>
      <!-- /.box-header -->
      <div class="box-body" id="load-preorders">
      </div>
      <div class="box-footer">
        <div class="pull-right">
          {{ Form::open(['route' => 'confirmPreOrder']) }}
          {{ Form::hidden('invoice_id', $invoiceId) }}
          <button type="submit" name="button" class="btn btn-primary btn-confirm"><i class="fa fa-check-square-o"></i> {{ trans('quotations.submit') }}</button>
          {{ Form::close() }}
        </div>
    </div>
  </div>
</div>
</section>
<div class="modal fade" tabindex="-1" role="dialog" id="newProduct">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title">{{ trans("dashboard.crud.add") }} {{ trans("products.product") }}</h4>
      </div>
      <div class="modal-body">
        {{ Form::open(['method' => "POST", 'route' => "quotations.qnewProduct", 'id' => 'formNewProduct']) }}
        <div class="row">
          <div class="col-md-12">
            {{ Form::hidden('quotation_id', $invoiceId) }}
            <div class="form-group">
              {{ Form::label('sku', Trans('products.sku')) }}
              {{ Form::text('sku', "", [
                  'class' => 'form-control',
                  "required"=>"required",
                  'id'  =>  "product-sku",
                  'placeholder' => Trans('products.sku')
              ])}}
            <span class="help-block msg-sku"></span>
            </div>
            <div class="form-group">
              <label for="product_name">{{ trans('products.name') }}</label>
              {{ Form::textarea('product_name', null, [
                'class' =>  "form-control",
                'rows'  =>  '3',
                'id'    =>  "product_name",
                'placeholder' =>  trans("products.name"),
                'required' =>  "required"
              ]) }}
            </div>
            <div class="form-group">
              <label for="amount">{{ trans('products.amount') }}</label>
              {{ Form::number("amount", null, [
                 'class'  =>  "form-control",
                 'id'     =>  "product_price",
                 'placeholder'  =>  trans("products.amount"),
                 'min'  =>  "1",
                 'required' =>  "required"
              ]) }}
            </div>
            <div class="form-group">
              <label for="price">{{ trans('products.price') }}</label>
              {{ Form::number("price", null, [
                 'class'  =>  "form-control",
                 'id'     =>  "product_price",
                 'placeholder'  =>  trans("products.price"),
                 'min'    =>  "1",
                 'step'   =>  "any",
                 'required' =>  "required"
              ]) }}
            </div>
          </div>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">{{ trans('dashboard.crud.cancel') }}</button>
        <button type="submit" class="btn btn-primary">{{ trans("dashboard.crud.add") }}</button>
        {{ Form::close() }}
      </div>
    </div><!-- /.modal-content -->
  </div><!-- /.modal-dialog -->
</div><!-- /.modal -->
@endsection
@section('addJs')
{{ HTML::script('production/js/quotation.js') }}
  <script>
    $(function() {
      $('#newProduct').on('shown.bs.modal', function () {
        $("#product-sku").focus();
      $('.msg-sku').hide();
      $("#product-sku").on('blur', function () {
        var parent = $(this).parent();
        if ($("#product-sku").val() == "") {
          // alert("Error");
        }
        $.ajax({
          type: "POST",
          url: "{{ route('product.check_unique_sku') }}",
          data: {
            "sku": $("#product-sku").val()
          },
          success: function (data) {
            if (data.error) {
              parent.addClass('has-error');
            } else {
              parent.removeClass('has-error');
              parent.addClass("has-success");
            }
            $(".msg-sku").show().text(data.messages);
          }
        });
      });
    });
     quotation.loadProduct();
      quotation.listPinStock();
      quotation.addNewProduct();
      quotation.editProductAmount();
      quotation.deleteProduct();
      quotation.addProduct(); 
});
  </script>
@endsection
