@extends('layouts.production')
@section('addCss')
<style media="screen">
  input[type=number].form-control {
    width: 50%;
  }
  .modal input[type=number].form-control {
    width: 100%;
  }
</style>
@endsection
@section('content')
<section class="content-header">
  <h1>
    {{ $supplier->company_name }}
    <small>{{ Trans('purchases.menu') }}</small>
    <span id="supplier_id" data-supplier-id="{{$supplier->id}}"></span>
  </h1>
  <ol class="breadcrumb">
    <li><a href="/"><i class="fa fa-dashboard"></i> {{ Trans('dashboard.home') }}</a></li>
    <li><a href="{{ route('suppliers.show', $supplier->id)}}"><i class="fa fa-da"></i> {{ $supplier->company_name }}</a></li>
    <li class="active">{{ Trans('purchases.menu') }}</li>
  </ol>
</section>
<!-- Main content -->
<section class="content">
@include('layouts.includes.message')
@include('purchases.inc.url')
<div class="row">
  <div class="col-md-12">
    <div class="box">
      <div class="box-header with-border">
        <h3 class="box-title">{{ trans('purchases.products_supplier')}}</h3>
      </div>
      <!-- /.box-header -->
      <div class="box-body">
        @include('purchases.inc.table_products')
      </div>
    </div>
  </div>
</div>
<div class="row">
  <div class="col-md-12">
    @include('purchases.inc.modal')
    @include('purchases.inc.table_orders')
  </div>
</div>
</section>
@endsection
@section('addJs')
  <script>
    $(function () {
        $.ajaxSetup({
          headers: {
              'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
          }
        });
        $("#example1").DataTable({
          "ajax"        : "{{Route('productsSupplier',$supplier->id)}}",
          "processing"  : true,
          "serverSide"  : true,
          "paging": true,
          "autoWidth": false,
          "columnDefs": [
            { "searchable": false, "targets": 4 },
            { "searchable": false, "targets": 5 }
          ],
          "columns": [
              {data: 'id', name: 'Products.id',title: '{{trans('products.sku')}}'},
              {data: 'name', name: 'Products.name',orderable: false,title: '{{trans('products.name')}}'},
              {data: 'name_kh', name: 'Products.name_kh',orderable: false,title: '{{trans('products.name_kh')}}'},
              {data: 'price_in', name: 'Products.price_in',orderable: false,title: '{{trans('products.price_in')}}'},{data: 'qty', name: 'qty',orderable: false,title: '{{trans('products.amount')}}' },
              {data: 'action', name: 'action',orderable: false,title: '{{trans('dashboard.crud.actions')}}'}
          ],
          initComplete: function () {
            this.api().columns([1,2,3]).every(function () {
                var column = this;
                var input = document.createElement("input");
                $(input).appendTo($(column.footer()).empty())
                .on('change', function () {
                    var val = $.fn.dataTable.util.escapeRegex($(this).val());
                    column.search(val ? val : '', true, false).draw();
                });
            });
          }
        });
      });
  </script>
  {{ HTML::script('production/js/purchase.js') }}
  <script type="text/javascript">
  $("document").ready(function(){
    purchaseOrder.listItem();
    purchaseOrder.cancelOrder();
    $(":submit").on('click', function(e){
      e.preventDefault();
    });
  });//end of document ready function
  </script>
@endsection
