@extends('layouts.production')
@section('addCss')
  <style media="screen">
    #table-list th {
      width: 180px;
      text-align: right;
      padding-right: 20px;
    }
    #example1 td {
      text-align: center;
    }
    table tr td {
      vertical-align: middle !important;
    }
  </style>

@endsection
@section('content')
  <section class="content-header">
    <h1>
      {{ str_limit($product->name,15,'...') }}
      <small>{{ str_limit($product->name_kh,30,'...') }}</small>
    </h1>
    <ol class="breadcrumb">
      <li><a href="/"><i class="fa fa-dashboard"></i> Home</a></li>
      <li><a href="{{ Route('productIndex')}}"><i class="fa fa-product-hunt"></i> {{ Trans('products.product') }}</a></li>
      <li class="active">{{ str_limit($product->name,30,'...') }}</li>
    </ol>
  </section>

  <!-- Main content -->
  <section class="content">
    @include('layouts.includes.message')
    <div class="row">
      <div class="col-md-12">
        <div class="box">
          <div class="box-header with-border">
            <div class="row">
              <div class="col-xs-12">
                @if(!empty($previous))
                <div class="pull-left"><a class="btn btn-info" href="{{ Route('product.show',$previous ) }}"><< {{ Trans('products.previous')}}</a></div>
                @endif
                @if(!empty($next))
                <div class="pull-right"><a  class="btn btn-info" href="{{ Route('product.show',$next ) }}">{{ Trans('products.next')}} >></a></div>
                @endif
              </div>
            </div>
          </div>
          <div class="box-body">
            <div class="col-md-8">
              <table class="table table-striped table-bordered" id="table-list">
                  <tr>
                    <th>{{ Trans('products.sku') }}</th>
                    <td>{{ $product->sku }}</td>
                  </tr>
                  <tr>
                    <th>{{ Trans('products.name') }}</th>
                    <td>{{ $product->name }}</td>
                  </tr>
                  <tr>
                    <th>{{ Trans('products.product_category') }}</th>
                    <td>{{ $product->category_name}}</td>
                  </tr>
                  <tr>
                    <th>{{ Trans('products.price_in') }}</th>
                    <td>{{ money($product->price_in) }}</td>
                  </tr>
                  <tr>
                    <th>{{ Trans('products.price') }}</th>
                    <td>{{ money($product->price) }}</td>
                  </tr>
                  <tr>
                    <th>{{ Trans('products.price_wholesale') }}</th>
                    <td>{{ money($product->price_wholesale) }}</td>
                  </tr>
                  <tr>
                    <th>{{ Trans('products.amount') }}</th>
                    <td>
                      {{ $product->amount }}
                      @if(UserRole::has("transfer_to_stock"))
                      {{Form::open(['method'=>'POST','route'=>['updateAmount',$product->id],'files'=>true,'class'=>'amount_update_form']) }}
                        {{ Form::number('amount',null,[
                            'class'=>'form-control',
                            'min'  => '1',
                            'required' => "required",
                            'placeholder' => trans('products.amount')
                        ])}}
                        <button type="submit" name="add" value="true" class="btn btn-success"><i class="fa fa-plus"></i> {{Trans('dashboard.crud.add')}}</button>
                        <button type="submit" name="substract" class="btn btn-danger"><i class="fa fa-minus"></i> {{Trans('products.out')}}</button>
                      {{ Form::close() }}
                      @endif
                    </td>
                  </tr>
                  <tr>
                    <th>{{ trans('products.on_hold') }}</th>
                    <td>{{ $product->on_hold }}</td>
                  </tr>
                  <tr>
                    <th>{{ trans('products.available_amount') }}</th>
                    <td>{{ $product->available_amount }}</td>
                  </tr>
                  @if ($product->min_amount > 0)
                  <tr>
                    <th>{{ Trans('products.min_amount') }}</th>
                    <td>{{ $product->min_amount }}</td>
                  </tr>
                  @endif
                  @if ($product->max_amount > 0)
                  <tr>
                    <th>{{ Trans('products.max_amount') }}</th>
                    <td>{{ $product->max_amount }}</td>
                  </tr>
                  @endif
                  @if ($product->expired_date)
                  <tr>
                    <th>{{ Trans('products.expired_date') }}</th>
                    <td>{{ $product->expired_date }}</td>
                  </tr>
                  @endif
                  <tr>
                    <th>{{ Trans('products.supplier') }}</th>
                    <td>{{ $product->supplier_name }}</td>
                  </tr>
                  <tr>
                    <th>{{ Trans('products.is_service') }}</th>
                    <td>
                      @if($product->is_service)
                        Yes
                      @else
                        No
                      @endif
                    </td>
                  </tr>
                  <tr>
                    <th>{{ trans('products.status') }}</th>
                    <td>
                      <span class="label {{ $product->status == 'active' ? 'label-info' : 'label-warning' }}">{{ trans("products.ps.".$product->status) }}</span>

                    </td>
                  </tr>
                  <tr>
                    <th>{{ Trans('products.item_location') }}</th>
                    <td>{{ $product->location_name }}</td>
                  </tr>
                  <tr>
                    <th>{{ Trans('products.unit') }}</th>
                    <td>{{ $product->unit }}</td>
                  </tr>
                  <tr>
                    <th>{{ Trans('products.comment') }}</th>
                    <td>{{ $product->comment }}</td>
                  </tr>
                </table>
            </div>
            <div class="col-md-4">
              {{ HTML::image($product->thumbnail, $product->name, ['class' => 'img-responsive img-thumbnail'])}}          
            </div>
          </div>
        </div>
      </div>
    </div>
    <div class="row">
      <div class="col-sm-12">
        <div class="box box-info">
          <div class="box-header with-border">
            <h3 class="box-title">{{ Trans('messages.captions.transaction_history')}}
            </h3>
          </div>
          <div class="box-body">
            <table id="example2" class="table table-bordered">
              <thead >
                <tr >
                  <th>#</th>
                  <th>{{Trans("products.name")}}</th>
                  <th>{{Trans("products.ref_id")}}</th>
                  <th>{{Trans("products.amount")}}</th>
                  <th>{{Trans("products.by")}}</th>
                  <th>{{Trans("dashboard.crud.created_at")}}</th>
                  <th>{{Trans('products.operation_type') }}</th>
                  <th>{{Trans("dashboard.crud.actions")}}</th>
                </tr>
              </thead>
              <tbody>
                @foreach($histories as $history)
                  <tr data-history="{{$history->id}}" data-url="{{Route('update_ref',$history->id)}}">
                    <td>{{ $history->id }}</td>
                    <td>{{ str_limit($history->pname,30,'...') }}</td>
                    <td>{{  Form::text('ref_id',$history->ref_id,['class'=>'form-control input-sm']) }}</td>
                    <td>{{$history->amount }}</td>
                    <td>{{ getField("User","id",$history->user_id,"first_name") }}</td>
                    <td>{{ $history->created_at }}</td>
                    <td>{{ Trans('products.'.$history->operation_type) }}</td>
                    <td>
                      @if(UserRole::has('update_ref'))
                        <a href="#" class="btn btn-xs btn-info save_ref_id">{{Trans("dashboard.crud.update")}} {{Trans("products.ref_id")}}</a>
                      @endif
                    </td>
                  </tr>
                @endforeach
                <tr>
                  <td colspan="9" class="text-right">Total Histories : {{ $histories->getTotal() }}</td>
                </tr>
              </tbody>
            </table>
            <p class="pull-right">{{ $histories->links() }}</p>
          </div>
        </div>
      </div>
    </div>
  </section>
@endsection
@section('addJs')
  {{ HTML::script('js/products.js')}}

@endsection
