@extends('layouts.production')
@section('content')
<section class="content-header">
  <h1>
    {{ Trans('products.min_amount') }}
    <small>{{ Trans('suppliers.show') }}</small>
  </h1>
  <ol class="breadcrumb">
    <li><a href="/"><i class="fa fa-dashboard"></i> {{ Trans('dashboard.home') }}</a></li>
    <li><a href="/product"><i class="fa fa-product-hunt"></i>{{ Trans('products.product') }}</a></li>
    <li class="active">{{ Trans('products.min_amount') }}</li>
  </ol>
</section>
<!-- Main content -->
<section class="content">
@include('layouts.includes.message')
<div class="row">
  <div class="col-md-12">
    <div class="box">
      <div class="box-header">
        <h3 class="box-title with-border">
          {{ trans('dashboard.others.show_all') }}
        </h3>
      </div>
      <!-- /.box-header -->
      <div class="box-body">
        <table id="example1" class="table table-bordered table-striped">
          <thead>
            <tr>
              <th>{{ trans('products.sku') }}</th>
              <th>{{ Trans('products.name') }}</th>
              <th>{{ Trans('products.amount') }}</th>
              <th>{{ Trans('products.min_amount') }}</th>
              <th>{{ Trans('products.max_amount') }}</th>
              <th>{{ Trans('products.order_amount') }}</th>
              <th>{{ Trans('dashboard.crud.actions') }}</th>
            </tr>
          </thead>
          <tbody>
            @foreach($products as $product)
              <tr>
                <td>{{ $product->sku }}</td>
                <td>{{ $product->name }}</td>
                <td>{{ $product->amount }}</td>
                <td>{{ $product->min_amount }}</td>
                <td>{{ $product->max_amount }}</td>
                <td>{{ $product->order_amount > 0 ? $product->order_amount : "" }}</td>
                <td>
                  <a href="{{ Route("product.show",$product->id) }}" class="btn btn-xs btn-default">{{Trans("dashboard.others.see")}}</a>
                </td>
              </tr>
            @endforeach
          </table>
          <p>{{ $products->links() }}</p>
        </div>
        <!-- /.box-body -->
      </div>
      <!-- /.box -->
    </div>
  </div>
</section>
@endsection