@extends('layouts.production')
@section('addCss')
<style>
  #example1 tr td {
    vertical-align: top;
  }
</style>
@endsection
@section('content')
  <section class="content-header">
    <h1>
      {{ Trans('products.product') }}
      <small>{{ Trans('products.table') }}</small>
    </h1>
    <ol class="breadcrumb">
      <li><a href="/"><i class="fa fa-dashboard"></i> Home</a></li>
      <li class="active">{{ Trans('products.product') }}</li>
    </ol>
  </section>
  <!-- Main content -->
  <section class="content">
  @include('layouts.includes.message')
    <div class="row">
      <div class="col-md-12">
        <div class="box">
          <!-- /.box-header -->
          <div class="box-body">
            <table id="example1" class="table table-bordered table-striped table-responsive">
            </table>
          </div>
          <!-- /.box-body -->
        </div>
        <!-- /.box -->
      </div>
    </div>
    {{ Form::close() }}
  </section>
@endsection
@section('addJs')
  <script>
    $(function () {
      $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
      });
      $("#example1").DataTable({
        "ajax"        : "{{Route('getProducts')}}",
        "processing"  : true,
        "serverSide"  : true,
        "paging": true,
        "autoWidth": false,
        "columnDefs": [
       		{ "targets": 0, "orderable": false},
          { "searchable": false, "targets":  8},
          { 'className': "hidden-md hidden-sm", "targets": [5]},
          { 'className': "limited-width", "targets": [2,3]}
        ],
        "columns": [
            {data: 'sku', name: 'p.sku', orderable: false, title: '{{ Trans('products.sku') }}'},
            {data: 'name', name: 'p.name',orderable: false,title: '{{ Trans('products.name') }}'},
            {data: 'amount', name: 'o.amount',orderable: false,title: '{{ Trans('products.amount') }}'},
            {data: 'on_hold', name: 'o.on_hold',orderable: false,title: '{{ Trans('products.on_hold') }}'},
            {data: 'available_amount', name: 'o.available_amount',orderable: false,title: '{{ Trans('products.available_amount') }}'},
            {data: 'price', name: 'p.price',orderable: false,title: '{{ Trans('products.price') }}'},
            {data: 'brand', name: 'b.name',orderable: false,title: '{{ Trans('brands.menu') }}'},
            {data: 'category', name: 'pc.name',orderable: false, title: '{{ Trans('products.product_category') }}'},
            {data: 'action', name: 'action',orderable: false,title: '{{ Trans('dashboard.crud.actions') }}'},

        ],
        initComplete: function () {
          this.api().columns([1,2,3]).every(function () {
              var column = this;
              var input = document.createElement("input");
              $(input).appendTo($(column.footer()).empty())
              .on('change', function () {
                  var val = $.fn.dataTable.util.escapeRegex($(this).val());
                  column.search(val ? val : '', true, false).draw();
              });
          });
        }
      });
    });
  </script>
  {{ HTML::script('js/products.js')}}
@endsection
