@extends('layouts.production')
@section('content')
<section class="content-header">
  <h1>
    Import Product By Excel
  </h1>
  <ol class="breadcrumb">
    <li><a href="/"><i class="fa fa-dashboard"></i> {{ Trans('dashboard.home') }}</a></li>
    <li class="active">Import File</li>
  </ol>
</section>
<!-- Main content -->
<section class="content">
@include('layouts.includes.message')
<div class="row">
  <div class="col-md-3">
    <div class="box">
      <div class="box-header with-border">
        <h3 class="box-title">Upload</h3>
      </div>
      <!-- /.box-header -->
      <div class="box-body">
        {{ Form::open(['method' => 'POST', 'route' => ['importProduct'],'files' => true]) }}
        <div class="form-group">
          {{ Form::label('import_file','Import Excel File') }}
          {{ Form::file('excel_file', [
            'class' => 'form-control'
          ]) }}
        </div>
        <div class="form-group pull-right">
          <button type="submit" name="submit" class="btn btn-info">Process</button>
        </div>
      </div>
    </div>
  </div>
  <div class="col-md-9">
    <div class="box">
      <div class="box-header with-border">
        <h3 class="box-title">Example Excel</h3>
      </div>
      <!-- /.box-header -->
      <div class="box-body">
        <img src="{{asset('exports/example.png')}}" alt="" class="img-responsive">
      </div>
    </div>
  </div>
</div>
@endsection
