@extends('layouts.production')
@section('content')
  <section class="content-header">
    <h1>
      {{ Trans('products.product') }}
      <small>{{ Trans('products.edit') }}</small>
    </h1>
    <ol class="breadcrumb">
      <li><a href="/"><i class="fa fa-dashboard"></i> Home</a></li>
      <li><a href="{{ Route('productIndex') }}"><i class="fa fa-product-hunt"></i> {{ Trans('products.product') }}</a></li>
      <li class="active">{{ Trans('dashboard.crud.edit') }}</li>
    </ol>
  </section>

  <!-- Main content -->
  <section class="content">
  @include('layouts.includes.message')
  {{Form::model($product,['method'=>'patch','route'=>['product.update',$product->id],'files'=>true]) }}
    @include('products.inc.formv2')
  {{ Form::close() }}
  @include('products.quick_forms.modal')
  </section>
@endsection
@section('addJs')
  {{ HTML::script('plugins/datepicker/bootstrap-datepicker.js') }}
  {{ HTML::script('plugins/datepicker/locales/bootstrap-datepicker.kh.js') }}
  {{ HTML::script('production/js/webcam.js') }}
  {{ HTML::script('production/js/products.js') }}
@endsection
