@extends('layouts.production')
@section("addCss")
<style>
  .msg-sku { font-size: 10px !important; margin-bottom: 0px; }
</style>
@endsection
@section('content')
  <section class="content-header">
    <h1>
      {{ Trans('products.product') }}
      <small>{{ Trans('products.duplicate') }}</small>
    </h1>
    <ol class="breadcrumb">
      <li><a href="/"><i class="fa fa-dashboard"></i> Home</a></li>
      <li><a href="{{ Route('productIndex') }}"><i class="fa fa-product-hunt"></i> {{ Trans('products.product') }}</a></li>
      <li class="active">{{ Trans('dashboard.crud.edit') }}</li>
    </ol>
  </section>

  <!-- Main content -->
  <section class="content">
  @include('layouts.includes.message')
  {{Form::model($product,['method'=>'post','route'=>['product.store',$product->id],'files'=>true]) }}
    <div class="row">
  <div class="col-md-9">
    <div class="box box-info">
      <div class="box-header with-border">
        <h3 class="box-title">{{ trans('products.form')}}</h3>
      </div>
      <div class="box-body">
        <div class="row">
          <div class="col-md-4 form-group">
            {{ Form::label('sku', Trans('products.sku')) }}
            {{ Form::text('sku', "", [
                'class' => 'form-control',
                "required"=>"required",
                'id'  =>  "product-sku",
                'placeholder' => Trans('products.sku')
            ])}}
            <span class="help-block msg-sku"></span>
          </div>
          <div class="col-md-4 form-group {{ ($errors->first('name')) ? "has-error" : ""}}">
            {{ Form::label('name', Trans('products.name')) }}
            {{ Form::text('name', null, [
                'class' => 'form-control',
                "required"=>"required",
                'placeholder' => Trans('products.name')
            ])}}
            @if($errors->first('name'))
              <span class="help-block">{{$errors->first('name')}}</span>
            @endif
          </div>
          <div class="col-md-4 form-group {{ ($errors->first('name_kh')) ? "has-error" : ""}}">
            {{ Form::label('name_kh', Trans('products.name_kh')) }}
            {{ Form::text('name_kh', null, [
                'class' => 'form-control',
                'placeholder' => Trans('products.name_kh')
            ])}}
            @if($errors->first('name_kh'))
              <span class="help-block">{{$errors->first('name_kh')}}</span>
            @endif
          </div>
        </div>
        <div class="row">
          <div class="col-md-4 form-group">
            {{ Form::label('price_in', Trans('products.price_in')) }}
            <div class="input-group">
              <span class="input-group-addon">{{getCurrencySign()}}</span>
              {{ Form::number('price_in', null, [
                  'class' => 'form-control',
                  'step'  => "any",
                  'min'   => '0',
                  "required"=>"required",
                  ((!isset($product)) || isset($product) && UserRole::has('change_product_price')) ? "" : "disabled",
                  'placeholder' => Trans('products.price_in')
              ])}}
            </div>
          </div>
          {{-- Price Section --}}
          <div class="col-md-4 form-group">
            {{ Form::label('price', Trans('products.price')) }}
            <div class="input-group">
              <span class="input-group-addon">{{getCurrencySign()}}</span>
              {{ Form::number('price', null, [
                  'class' => 'form-control',
                  'step'  => "any",
                  'min'   => '0',
                  "required"=>"required",
                  ((!isset($product)) || isset($product) && UserRole::has('change_product_price')) ? "" : "disabled",
                  'placeholder' => Trans('products.price')
              ])}}
            </div>
          </div>
          <div class="col-md-4 form-group">
            {{ Form::label('price_wholesale', Trans('products.price_wholesale')) }}
            <div class="input-group">
              <span class="input-group-addon">{{getCurrencySign()}}</span>
              {{ Form::number('price_wholesale', null, [
                  'class' => 'form-control',
                  'step'  => "any",
                  'min'   => '0',
                  "required"=>"required",
                  ((!isset($product)) || isset($product) && UserRole::has('change_product_price')) ? "" : "disabled",
                  'placeholder' => Trans('products.price_wholesale')
              ])}}
            </div>
          </div>
        </div>
        <div class="row">
          <div class="col-md-3 form-group">
            {{ Form::label('discount', Trans('products.discount')) }}
            <div class="input-group">
              <span class="input-group-addon">%</span>
              {{ Form::number('discount', "", [
                  'class' => 'form-control',
                  'min'   => '0',
                  'placeholder' => Trans('products.discount')
              ])}}
            </div>
          </div>
          <div class="col-md-3 form-group">
            {{ Form::label('amount', Trans('products.amount')) }}
            {{ Form::number('amount', "", [
                'class' => 'form-control',
                'min' => '1',
                "required"=>"required",
                'placeholder' => Trans('products.amount')
            ])}}
          </div>
          <div class="col-md-3 form-group">
            {{ Form::label('min_amount', Trans('products.min_amount')) }}
            {{ Form::number('min_amount', "", [
                'class' => 'form-control',
                'min' => '0',
                'placeholder' => Trans('products.min_amount')
            ])}}
          </div>
          <div class="col-md-3 form-group">
            {{ Form::label('max_amount', Trans('products.max_amount')) }}
            {{ Form::number('max_amount', "", [
                'class' => 'form-control',
                'min' => '0',
                'placeholder' => Trans('products.max_amount')
            ])}}
          </div>
        </div>
        <div class="row">
          <div class="col-md-3 form-group">
            {{ Form::label('expired_date', Trans('products.expired_date')) }}
            <div class="input-group date" data-provide="datepicker">
              {{ Form::text('expired_date', null, [
                'class' => "form-control",
                'placeholder' => Trans('products.expired_date')
              ]) }}
              <div class="input-group-addon">
                  <i class="fa fa-calendar"></i>
              </div>
            </div>
          </div>
          <div class="col-md-3 form-group">
            {{ Form::label('brand_id', Trans('brands.menu')) }}

            <?php $selected = isset($product->brand_id) ? $product->brand_id : "0"; ?>
            <div class="input-group">
              {{ Form::select('brand_id', $brands, $selected, ['class' => 'select2  form-control']) }}
              <span class="input-group-btn">
                <a class="btn btn-default" id="add_brand" title="Add Brand" data-toggle="modal" data-target="#brand-modal"><i class="glyphicon glyphicon-plus"></i></a>
              </span>
            </div>
          </div>
          <div class="col-md-3 form-group">
            {{ Form::label('unit_id', Trans('products.unit')) }}

            <?php $selected = isset($product->unit_id) ? $product->unit_id : "0"; ?>
            <div class="input-group">
              {{ Form::select('unit_id', $units, $selected, ['class' => 'select2  form-control']) }}
              <span class="input-group-btn">
                <a class="btn btn-default" id="add_unit" title="Add Unit" data-toggle="modal" data-target="#unit-modal"><i class="glyphicon glyphicon-plus"></i></a>
              </span>
            </div>
          </div>
          <div class="col-md-3 form-group">
            <?php
            $selected = isset($product->product_category_id) ? $product->product_category_id : "0";
             ?>
            {{ Form::label('product_category_id', Trans('products.product_category')) }}
            <div class="input-group">
              {{ Form::select('product_category_id', $categories,
                $selected, ['class' => 'form-control select2 categories']) }}
                <span class="input-group-btn">
                  <a class="btn btn-default" id="quick_add_category" title="Quick Add" data-toggle="modal" data-target="#addCategory"><i class="glyphicon glyphicon-plus"></i></a>
                </span>
            </div>
          </div>
        </div>
        <div class="row">
          <div class="col-md-4 form-group">
            <?php
            $selected = isset($product->item_location_id) ? $product->item_location_id : "0";
             ?>
            {{ Form::label('item_location_id', Trans('products.item_location')) }}
            <div class="input-group">
              {{ Form::select('item_location_id', $item_locations, $selected, ['class' => 'select2 form-control']) }}
              <span class="input-group-btn">
                <a class="btn btn-default" id="add_item_location" title="Add Item Location" data-toggle="modal" data-target="#item-location-modal"><i class="glyphicon glyphicon-plus"></i></a>
              </span>
            </div>
          </div>
          <div class="col-md-4 form-group">
            <?php
            $selected = isset($product->supplier_id) ? $product->supplier_id : "0";
             ?>
            {{ Form::label('supplier_id', Trans('products.supplier')) }}
            <div class="input-group">
              {{ Form::select('supplier_id', $suppliers, $selected, ['class' => 'select2 form-control']) }}
              <span class="input-group-btn">
                <a class="btn btn-default" id="add_item_location" title="Add Item Location" data-toggle="modal" data-target="#supplier-modal"><i class="glyphicon glyphicon-plus"></i></a>
              </span>
            </div>
          </div>
          <div class="col-md-4 form-group">
            {{ Form::label('ref_id', Trans('products.ref_id')) }}
            {{ Form::text('ref_id', null, [
                'class' => 'form-control',
                'min' => '0',
                'placeholder' => Trans('products.ref_id')
            ])}}
          </div>
        </div>
        <div class="row">
          <div class="col-md-4 form-group">
            {{ Form::label('comment', Trans('products.comment')) }}
            {{ Form::textarea('comment', null, [
                'class' => 'form-control',
                'placeholder' => Trans('products.comment'),
                'rows'  => '3'
            ])}}
          </div>
          <div class="col-md-4 form-group">
            <?php
              if(App::getLocale() == "kh") {
                $service = [
                  '1' => 'បាទ / ចាស់',
                  '0' => 'មិនមែនទេ'
                ];
              }
              else {
                $service = [
                  '1' => 'Yes',
                  '0' => 'No'
                ];
              }
            ?>
            <?php
            $selected = isset($product) ? $product->category_id : "0";
             ?>
            {{ Form::label('is_service', Trans('products.is_service')) }}
            {{ Form::select('is_service', $service, $selected, ['class' => 'form-control']) }}
          </div>
          <div class="col-md-4 form-group">
            <div class="checkbox">
                <label>
                    <?php $checked = isset($product) ? $product->feature_item : 1;  ?>
                    {{ Form::checkbox('feature_item', '1', $checked) }}
                    {{ trans('products.feature')}}
                </label>
            </div>
            <div class="checkbox">
                <label>
                    <?php $checked = isset($product->turn_off_notification) ? $product->turn_off_notification : 0;  ?>
                    {{ Form::checkbox('turn_off_notification', '1', $checked) }}
                    {{ trans('products.alert_message')}}
                </label>
            </div>
          </div>
        </div>
        <div class="form-group pull-right">
          <button type="submit" name="submit" class="btn btn-info">
            {{ trans('products.copy') }}
          </button>
        </div>
      </div>
    </div>
  </div>
  <div class="col-md-3">
    <div class="box">
      <div class="box-header with-border">
        <h3 class="box-title">{{ trans('products.image')}}</h3>
      </div>
      <div class="box-body">
        @if (isset($product->id))
            <img src="{{$product->thumbnail}}" alt="" class="img img-thumbnail img-responsive">
            <br><br>
        @endif
        <div class="form-group">
          {{ Form::label('thumbnail', Trans('products.thumbnail')) }}
          {{ Form::file('thumbnail', ['accept'=>"image/*",'capture'=>'camera',
            'class' => "form-control",
          ]) }}
        </div>
        <div class="row">
          <div class="col-md-12">
            <div class="form-group">
              <div id="my_camera"></div>
            </div>
          </div>
          <div class="col-md-12">
            <div class="form-group">
              <div id="results" class="preview-area"></div>
            </div>
          </div>
        </div>
        <textarea id="image_name" name="image_name" style="display:none;"></textarea>
        <div class="form-group">
          <button type="button" onClick="preview_snapshot()" class="preview_snapshot btn btn-success"><i class="fa fa-play-circle-o"></i> {{Trans("users.take_snapshot")}}</button>
          <button type="button" onClick="start_webcam()" class="start_webcam btn btn-default"><i class="fa fa-camera"></i> {{Trans("users.start_webcam")}}</button>
          <button type="button" onClick="closeWebCam()" class="cancel_preview btn btn-danger"><i class="fa fa-stop"></i> Stop</button>
        </div>
      </div>
    </div>
  </div>
</div>

  {{ Form::close() }}
  @include('products.quick_forms.modal')
  </section>
@endsection
@section('addJs')
  {{ HTML::script('plugins/datepicker/bootstrap-datepicker.js') }}
  {{ HTML::script('plugins/datepicker/locales/bootstrap-datepicker.kh.js') }}
  {{ HTML::script('production/js/webcam.js') }}
  {{ HTML::script('production/js/products.js') }}
  <script>
    $(function () {
      $("#product-sku").focus();
      $('.msg-sku').hide();
      $("#product-sku").on('blur', function () {
        var parent = $(this).parent();
        if ($("#product-sku").val() == "") {
          // alert("Error");
        }
        $.ajax({
          type: "POST",
          url: "{{ route('product.check_unique_sku') }}",
          data: {
            "sku": $("#product-sku").val()
          },
          success: function (data) {
            if (data.error) {
              parent.addClass('has-error');
            } else {
              parent.removeClass('has-error');
              parent.addClass("has-success");
            }
            $(".msg-sku").show().text(data.messages);
          }
        });
      });
    });
  </script>
@endsection
