@extends('layouts.production')
@section("addCss")
<style>
  .msg-sku { font-size: 10px !important; margin-bottom: 0px; }
</style>
@endsection
@section('content')
  <section class="content-header">
    <h1>
      {{ Trans('products.product') }}
      <small>{{ Trans('products.create') }}</small>
    </h1>
    <ol class="breadcrumb">
      <li><a href="/"><i class="fa fa-dashboard"></i> Home</a></li>
      <li><a href="{{ Route('productIndex') }}"><i class="fa fa-product-hunt"></i> {{ Trans('products.product') }}</a></li>
      <li class="active">{{ Trans('dashboard.crud.add') }}</li>
    </ol>
  </section>

  <!-- Main content -->
  <section class="content">
  @include('layouts.includes.message')
  {{ Form::open(array('route' => 'product.store','method'=>'POST','files' => true)) }}
    @include('products.inc.formv2')
  {{ Form::close() }}
  @include('products.quick_forms.modal')
  </section>
@endsection
@section('addJs')
  {{ HTML::script('plugins/datepicker/bootstrap-datepicker.js') }}
  {{ HTML::script('plugins/datepicker/locales/bootstrap-datepicker.kh.js') }}
  {{ HTML::script('production/js/webcam.js') }}
  {{ HTML::script('production/js/products.js') }}
  <script>
    $(function () {
      $('.msg-sku').hide();
      $("#product-sku").on('blur', function () {
        var parent = $(this).parent();
        $.ajax({
          type: "POST",
          url: "{{ route('product.check_unique_sku') }}",
          data: {
            "sku": $("#product-sku").val()
          },
          success: function (data) {
            if (data.error) {
              parent.addClass('has-error');
            } else {
              parent.removeClass('has-error');
              parent.addClass("has-success");
            }
            $(".msg-sku").show().text(data.messages);
          }
        });
      });
    });
  </script>
@endsection
