@extends('layouts.production')
@section('content')
<section class="content-header">
  <h1>
    {{ Trans('products.products_expire') }}
    <small>{{ Trans('suppliers.show') }}</small>
  </h1>
  <ol class="breadcrumb">
    <li><a href="/"><i class="fa fa-dashboard"></i> {{ Trans('dashboard.home') }}</a></li>
    <li><a href="/product"><i class="fa fa-product-hunt"></i>{{ Trans('products.product') }}</a></li>
    <li class="active">{{ Trans('products.products_expire') }}</li>
  </ol>
</section>
<!-- Main content -->
<section class="content">
@include('layouts.includes.message')
<div class="row">
  <div class="col-md-12">
    <div class="box">
      <!-- /.box-header -->
      <div class="box-body">
        <table id="example1" class="table table-bordered table-striped">
          <thead>
            <tr>
              <th>#</th>
              <th>{{ Trans('products.name') }}</th>
              <th>{{ Trans('products.name_kh') }}</th>
              <th>{{ Trans('products.expired_date') }}</th>
              <th>{{ Trans('dashboard.crud.actions') }}</th>
            </tr>
          </thead>
          <tbody>
            @foreach($products as $product)
              <tr>
                <td>{{ $product->id }}</td>
                <td>{{ $product->name }}</td>
                <td>{{ $product->name_kh }}</td>
                <td>{{ $product->expired_date }}</td>
                <td>
                  <a href="{{ Route("product.show",$product->id) }}" class="btn btn-xs btn-default">{{Trans("dashboard.others.see")}}</a>
                  @if(UserRole::has('edit_product'))
                  <a href="{{ Route("product.edit",$product->id) }}" class="btn btn-xs btn-info">{{Trans("dashboard.crud.edit")}}</a>
                  @endif
                  @if(UserRole::has('delete_product'))
                  <a href="#" class="btn btn-xs btn-danger" data-toggle="modal" data-target="#myModal{{$product->id}}">{{Trans("dashboard.crud.remove")}}</a>
                  @include('layouts.includes.modals.danger', ['model' => $product,'toRoute'=>'product','attribute'=>'name'])
                  @endif
                </td>
              </tr>
            @endforeach
            <tfoot>
              <tr>
                <th>#</th>
                <th>{{ Trans('products.name') }}</th>
                <th>{{ Trans('products.name_kh') }}</th>
                <th>{{ Trans('products.expired_date') }}</th>
                <th>{{ Trans('dashboard.crud.actions') }}</th>
              </tr>
            </tfoot>
          </table>
        </div>
        <!-- /.box-body -->
      </div>
      <!-- /.box -->
    </div>
  </div>
  {{ Form::close() }}
</section>
@endsection
@section('addJs')
<script>
  $(function () {
    $("#example1").DataTable();
    $('#example2').DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": false,
      "ordering": true,
      "info": true,
      "autoWidth": false
    });
  });
</script>
@endsection
