@extends('layouts.production')
@section('addCss')
    <style media="screen">
        #example2_filter input[type=search] {
            width: 200px;
        }
        .table td { vertical-align: middle !important;}
    </style>
@endsection
@section('content')
    <section class="content-header">
        <h1>
            {{Trans("mortgages.menu")}}
        </h1>
        <ol class="breadcrumb">
            <li><a href="/"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="{{ Route('mortgages.index') }}"><i class="fa fa-credit-card"></i> {{ Trans('mortgages.menu')}}</a></li>
            <li class="active">{{Trans("mortgages.today_payment") }}</li>
        </ol>
    </section>

    <!-- Main content -->

    <section class="content">
        @include('layouts.includes.message')
        <div class="row">
            <div class="col-md-12">
                <div class="box box-warning">
                    <div class="box-header with-border">
                        <h3 class="box-title">{{ trans('mortgages.today_payment') }}</h3>
                    </div>
                    <div class="box-body">
                        <div class="table-responsive">
                            <table class="table table-striped​ table-bordered">
                                <thead>
                                <tr>
                                    <th style="width: 10%;">{{ trans('installments.id') }}</th>
                                    <th>{{ trans("installments.code") }}</th>
                                    <th>{{ trans("payments.customer") }}</th>
                                    <th colspan="2">{{ trans('installments.date_payment')}}</th>
                                    <th>{{ trans('mortgages.total_payment') }}</th>
                                    <th style="width: 15%;">{{ trans('dashboard.crud.actions') }}</th>
                                </tr>
                                </thead>
                                <tbody>
                                @if (count($payments) > 0)
                                    <?php $i =1; ?>
                                    @foreach ($payments as $pay)
                                        <tr>
                                            <td>{{ $i }}</td>
                                            <td><a href="{{ route('mortgages.show', $pay->m_id) }}">{{ convertInvoiceNumber($pay->m_id) }}</a></td>
                                            <td>{{ $pay->fullname }} ({{ $pay->tel }})</td>
                                            <td style="width: 10%;">{{ get_day_week($pay->payment_date) }}</td>
                                            <td>{{ format_date_installment($pay->payment_date) }}</td>
                                            <td>{{ money($pay->amount) }}</td>
                                            <td>
                                                <a href="{{ route('mortgages.show', $pay->m_id) }}" class="btn btn-sm btn-default"><i class="fa fa-th-list"></i> {{ trans('dashboard.others.show') }}</a>
                                            </td>
                                        </tr>
                                        <?php $i++; ?>
                                    @endforeach
                                @endif
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
