@extends('layouts.production')
@section('addCss')
    <style media="screen">
        table td { vertical-align: middle !important; }
    </style>
    {{ HTML::style('https://cdnjs.cloudflare.com/ajax/libs/ekko-lightbox/5.3.0/ekko-lightbox.css') }}
@endsection
@section('content')
    <section class="content-header">
        <h1>
            {{Trans("mortgages.menu")}}
            <small>{{Trans("dashboard.others.detail")}}</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="/"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="{{ Route('mortgages.index') }}"><i class="fa fa-credit-card"></i> {{ Trans('mortgages.menu')}}</a></li>
            <li class="active">{{Trans("dashboard.others.detail")}}</li>
        </ol>
    </section>
    <!-- Main content -->

    <section class="content">
        @include('layouts.includes.message')
        @include("mortgages.modal")
        <div class="row">
            <div class="col-md-12">
                <div class="box box-info">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-th-list"></i> {{ trans('mortgages.detail') }}
                            @if ($mortgage->status == "pendding")
                                <span class="label label-warning">{{ trans("mortgages.".$mortgage->status) }}</span>
                            @elseif ($mortgage->status == "progressing")
                                <span class="label label-info">{{ trans("mortgages.".$mortgage->status) }}</span>
                            @else
                                <span class="label label-success">{{ trans("mortgages.".$mortgage->status) }}</span>
                            @endif
                        </h3>
                        <div class="pull-right">
                            @if (($mortgage->status != "completed" && $mortgage->price > $mortgage->getPrice()) || get_config('can_add_more_below_price') == "yes")
                            <a href="{{ route('mortgages.addMore', $mortgage->id) }}" class="btn btn-sm btn-primary btn-show-modal" data-title="{{ trans('mortgages.form_add_more') }}"><i class="fa fa-plus"></i> {{ trans("mortgages.add_more") }}</a>
                            @endif
                            @if ($mortgage->status == "pendding")
                            <a href="{{ route('mortgages.edit', $mortgage->id) }}" class="btn btn-sm btn-success"><i class="fa fa-edit"></i> {{ trans('dashboard.crud.edit') }}</a>
                            @endif
                            <a href="{{ route('mortgages.print', $mortgage->id) }}" target="_blank" class="btn btn-sm btn-default"><i class="fa fa-print"></i> {{ trans('dashboard.others.print') }}</a>
                        </div>
                    </div>
                    <div class="box-body">
                        <div class="row">
                            <div class="col-md-4">
                                <table class="table table-bordered table-striped">
                                    <tr>
                                        <th style="width: 40%;">{{ trans("mortgages.id") }}</th>
                                        <td>{{ convertInvoiceNumber($mortgage->id) }}</td>
                                    </tr>
                                    <tr>
                                        <th>{{ trans("mortgages.customer") }}</th>
                                        <td>{{ $mortgage->fullname }}</td>
                                    </tr>
                                    <tr>
                                        <th>{{ trans('mortgages.id_card') }}</th>
                                        <td>{{ $mortgage->id_card }}</td>
                                    </tr>
                                    <tr>
                                        <th>{{ trans('mortgages.tel') }}</th>
                                        <td>{{ $mortgage->tel }}</td>
                                    </tr>
                                    <tr>
                                        <th>{{ trans("mortgages.address") }}</th>
                                        <td>{{ $mortgage->address }}</td>
                                    </tr>
                                </table>
                            </div>
                            <div class="col-md-8">
                                <table class="table table-bordered table-striped hidden-xs">
                                    <tr>
                                        <th>{{ trans("mortgages.product_name") }}</th>
                                        <td>{{ $mortgage->product_name }}</td>
                                        <th>{{ trans("mortgages.product_id") }}</th>
                                        <td>{{ $mortgage->product_id }}</td>
                                    </tr>
                                    <tr>
                                        <th>{{ trans("mortgages.start_date") }}</th>
                                        <td>{{ format_date_installment($mortgage->start_date) }}</td>
                                        <th>{{ trans("mortgages.end_date") }}</th>
                                        <td>{{ format_date_installment($mortgage->end_date) }}</td>
                                    </tr>
                                    <tr>
                                        <th>{{ trans("mortgages.price") }}</th>
                                        <td>{{ money($mortgage->price) }}</td>
                                        <th>{{ trans("mortgages.price_out") }}</th>
                                        <td>{{ money($mortgage->price_out) }}</td>
                                    </tr>
                                    @if ($mortgage->status == "completed")
                                        <tr>
                                            <th>{{ trans("mortgages.total_payment") }}</th>
                                            <td>{{ money($mortgage->total_payment) }}</td>
                                            <th>{{ trans("mortgages.paid_off_date") }}</th>
                                            <td>{{ format_date_installment($mortgage->paid_off_date) }}</td>
                                        </tr>
                                    @endif
                                    <tr>
                                        <th>{{ trans("mortgages.rate") }}</th>
                                        <td colspan="3">{{ $mortgage->rate}}%</td>
                                    </tr>
                                    <tr>
                                        <th>{{ trans('mortgages.note') }}</th>
                                        <td colspan="3">{{ $mortgage->note }}</td>
                                    </tr>
                                </table>
                                <!-- Show table in small device -->
                                <table class="table table-bordered table-striped visible-xs">
                                    <tr>
                                        <th>{{ trans("mortgages.product_name") }}</th>
                                        <td>{{ $mortgage->product_name }}</td>
                                    </tr>
                                    <tr>
                                        <th>{{ trans("mortgages.product_id") }}</th>
                                        <td>{{ $mortgage->product_id }}</td>
                                    </tr>
                                    <tr>
                                        <th>{{ trans("mortgages.start_date") }}</th>
                                        <td>{{ format_date_installment($mortgage->start_date) }}</td>
                                    </tr>
                                    <tr>
                                        <th>{{ trans("mortgages.end_date") }}</th>
                                        <td>{{ format_date_installment($mortgage->end_date) }}</td>
                                    </tr>
                                    <tr>
                                        <th>{{ trans("mortgages.price") }}</th>
                                        <td>{{ money($mortgage->price) }}</td>
                                    </tr>
                                    <tr>
                                        <th>{{ trans("mortgages.price_out") }}</th>
                                        <td>{{ money($mortgage->price_out) }}</td>
                                    </tr>
                                    @if ($mortgage->status == "completed")
                                        <tr>
                                            <th>{{ trans("mortgages.total_payment") }}</th>
                                            <td>{{ money($mortgage->total_payment) }}</td>
                                        </tr>
                                        <tr>
                                            <th>{{ trans("mortgages.paid_off_date") }}</th>
                                            <td>{{ format_date_installment($mortgage->paid_off_date) }}</td>
                                        </tr>
                                    @endif
                                    <tr>
                                        <th>{{ trans("mortgages.rate") }}</th>
                                        <td>{{ $mortgage->rate}}%</td>
                                    </tr>
                                    <tr>
                                        <th>{{ trans('mortgages.note') }}</th>
                                        <td>{{ $mortgage->note }}</td>
                                    </tr>
                                </table>

                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="box box-solid box-default">
                                    <div class="box-header">
                                        <h3 class="box-title"><i class="fa fa-photo"></i> Gallery</h3>
                                        @if($mortgage->status != "completed")
                                        {{ Form::open(['route' => ['mortgages.upload', $mortgage->id], 'class' => 'form-inline pull-right', 'files' => true]) }}
                                        {{ Form::hidden("id", $mortgage->id) }}
                                        {{ Form::label("photo", trans("mortgages.photo")) }}
                                        {{ Form::file("photo[]",
                                        [
                                            'class' => "form-control input-sm",
                                            'multiple' => true,
                                            'required' => 'required'
                                        ]) }}
                                        <button type="submit" class="btn btn-sm btn-primary"><i class="fa fa-upload"></i> Upload</button>
                                        {{ Form::close() }}
                                        @endif
                                    </div>
                                    <div class="box-body">
                                        @if(count($files) > 0)
                                        <div class="row">
                                            @foreach($files as $file)
                                                <a href="{{ imgUrl($file) }}" data-toggle="lightbox" data-gallery="example-gallery" class="col-md-3">
                                                    <img src="{{ imgUrl($file) }}" class="img img-responsive" style="margin-bottom: 5px;">
                                                </a>
                                            @endforeach
                                        </div>
                                            @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="box box-solid box-primary">
                                    <div class="box-header">
                                        <h3 class="box-title"><i class="fa fa-calendar-o"></i> {{ trans("mortgages.table_payment") }}
                                        </h3>
                                    </div>
                                    <div class="box-body">
                                        <div class="table-responsive">
                                            @include('mortgages.inc.table_payment')
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
@section('addJs')
    {{ HTML::script('https://cdnjs.cloudflare.com/ajax/libs/ekko-lightbox/5.3.0/ekko-lightbox.js') }}
    {{ HTML::script('plugins/datepicker/bootstrap-datepicker.js') }}
    {{ HTML::script('plugins/datepicker/locales/bootstrap-datepicker.kh.js') }}
    {{ HTML::script('js/mortgage.js') }}
    <script>
    $(document).on('click', '[data-toggle="lightbox"]', function(event) {
        event.preventDefault();
        $(this).ekkoLightbox();
    });
    </script>
@endsection
