<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Invoice V1</title>
    {{ HTML::style('css/installment.css') }}
    <style media="print">
        @page {
            size: A4;
            margin-top: 10px !important;
            margin: 10px;
            margin-left: 10px;

        }
        body { font-size: 12px !important; color: #000 !important; }
        img { width: 150px !important; }
        hr { border-color: #333333!important; margin-top: 0; margin-bottom: 0;}
        /*.table-nobordered { border: 1px solid #333333 !important; }*/
        .table-nobordered th, .table-nobordered td { border: 0 !important;  padding: 5px; color: #000 !important;}
        .table-nobordered { margin-bottom: 5px; }
        table, th, td { border-color: #333333 !important; padding: 5px !important; color: #000 !important;}
        th { border-bottom-width: 1px !important;}
        h2 { font-family: "Khmer OS Muol";}
        h2, h3, p { text-align: center; }
        h2 { font-size: 22px !important; margin-bottom: 5px !important; }
        h3 { font-size: 18px !important; margin-top: 0 !important; }
        p { margin: 5px !important; color: #000 !important;}
        table.table-paid{
            border: 1px solid #333;
        }
        table th { font-weight: bold !important; }
        .table-paid th, .table-paid td{
            border: 1px solid #333;
        }
        .table-paid tr td:last-child{
            border-right: none;
        }
        .strike-trough{
            position: relative;
        }
        .strike-trough:after{
            content: '';
            display: block;
            border-bottom: 1px solid #333;
            right: 0;
            position: absolute;
            left: 0;
            padding-top: 20px;
            margin-left: 15px;
            margin-right: 15px;
        }
        .logo { padding-top: 30px; padding-bottom: 40px; }
    </style>
    <style>
        hr { border-color: #333333!important; margin-top: 0; margin-bottom: 0;}
        /*.table-nobordered { border: 1px solid #333333 !important; }*/
        .table-nobordered th, .table-nobordered td { border: 0 !important; }
        table, th, td { border-color: #333333 !important;}
        th { border-bottom-width: 1px !important;}
        h2 { font-family: "Khmer OS Muol";}
        h2, h3, p { text-align: center; }
        table.table-paid{
            border: 1px solid #333;
        }
        .table-paid th, .table-paid td{
            border: 1px solid #333;
        }
        .table-paid tr td:last-child{
            border-right: none;
        }
        .strike-trough{
            position: relative;
        }
        .strike-trough:after{
            content: '';
            display: block;
            border-bottom: 1px solid #333;
            right: 0;
            position: absolute;
            left: 0;
            padding-top: 20px;
            margin-left: 15px;
            margin-right: 15px;
        }
        .logo { padding-top: 30px; padding-bottom: 40px; }
        .header { text-align: center;}
        .header p { margin-bottom: 5px !important;}
        {{ get_config('custom_style') }}
    </style>
</head>
<script>
    window.print();
</script>
<body>
<div class="container-fluid">
    <div class="row">
        <div class="col-xs-3" >
            {{ HTML::image(get_config('company_logo'), "Logo", ['width' => '200px;', 'class' => 'logo'])}}
        </div>
        <div class="col-xs-6">
            <div class="header">
                <h2>{{ get_config('company_name') }}</h2>
                <h3 style="margin-top: 10px; text-transform: uppercase;">{{ get_config('company_name_en') }}</h3>
                <p>{{ get_config('company_detail') }}</p>
                <p>{{ get_config('company_address')}}</p>
                <p>លេខទូរស័ព្ទ: {{ get_config('company_tel')}}</p>
                @if (get_config('company_facebook'))
                    <p>Facebook: {{ get_config("company_facebook") }}</p>
                @endif
            </div>
        </div>
        <div class="col-xs-3">
            @if(!empty(get_config('company_banner')))
                {{ HTML::image(get_config('company_banner'), "Banner", [
                    'class' => 'pull-right company_banner img-responsive'
                ]) }}
            @else
                {{ HTML::image('uploads/img.jpg', "IMG", ['class' => 'pull-right company_banner']) }}
            @endif
        </div>
    </div>

    <div class="row">
        <div class="col-xs-12">
            <h3 class="text-left">{{ trans('mortgages.menu') }}</h3>
        </div>
    </div>
    <div class="row">
        <div class="col-md-4">
            <table class="table table-bordered">
                <tr>
                    <th style="width: 40%">{{ trans("mortgages.id") }}</th>
                    <td>{{ convertInvoiceNumber($mortgage->id) }}</td>
                </tr>
                <tr>
                    <th>{{ trans("mortgages.user") }}</th>
                    <td>{{ $mortgage->first_name }} {{ $mortgage->last_name }}</td>
                </tr>
                <tr>
                    <th>{{ trans('mortgages.date') }}</th>
                    <td>{{ dt_format($mortgage->created_at) }}</td>
                </tr>

                <tr>
                    <th>{{ trans("mortgages.customer") }}</th>
                    <td>{{ $mortgage->fullname }}</td>
                </tr>
                <tr>
                    <th>{{ trans('mortgages.id_card') }}</th>
                    <td>{{ $mortgage->id_card }}</td>
                </tr>
                <tr>
                    <th>{{ trans('mortgages.tel') }}</th>
                    <td>{{ $mortgage->tel }}</td>
                </tr>
                <tr>
                    <th>{{ trans("mortgages.address") }}</th>
                    <td>{{ $mortgage->address }}</td>
                </tr>
            </table>
        </div>
        <div class="col-md-8">
            <table class="table table-bordered">
                <tr>
                    <th>{{ trans("mortgages.product_name") }}</th>
                    <td>{{ $mortgage->product_name }}</td>
                    <th>{{ trans("mortgages.product_id") }}</th>
                    <td>{{ $mortgage->product_id }}</td>
                </tr>
                <tr>
                    <th>{{ trans("mortgages.start_date") }}</th>
                    <td>{{ format_date_installment($mortgage->start_date) }}</td>
                    <th>{{ trans("mortgages.end_date") }}</th>
                    <td>{{ format_date_installment($mortgage->end_date) }}</td>
                </tr>
                <tr>
                    <th>{{ trans("mortgages.price") }}</th>
                    <td>{{ money($mortgage->price) }}</td>
                    <th>{{ trans("mortgages.price_out") }}</th>
                    <td>{{ money($mortgage->price_out) }}</td>
                </tr>
                <tr>
                    <th>{{ trans("mortgages.rate") }}</th>
                    <td>{{ $mortgage->rate}}%</td>
                    <th>{{ trans('mortgages.note') }}</th>
                    <td>{{ $mortgage->note }}</td>
                </tr>
            </table>
            <table class="table table-bordered">
                <thead>
                <tr>
                    <th>{{ trans('dashboard.id') }}</th>
                    <th>{{ trans("mortgages.payment_date") }}</th>
                    <th>{{ trans("mortgages.total_paid") }}</th>
                    <th>{{ trans("mortgages.paid_interest") }}</th>
                    <th style="width: 35%;" ​>{{ trans("mortgages.others") }}</th>
                </tr>
                </thead>
                <tbody>
                @if (count($payments) > 0)
                    <?php $i = 1; ?>
                    @foreach($payments as $payment)
                        <tr>
                            <td>{{ $i }}</td>
                            <td>{{ format_date_installment($payment->payment_date) }}</td>
                            <td>{{ money($payment->amount) }}</td>
                            <td>{{ money($payment->interest) }}</td>
                            <td>
                                @if ($payment->is_paid && $payment->is_paid_interest)
                                {{ trans("mortgages.has_paid_interest") }}
                                @endif
                                @if ($payment->is_paid && $payment->is_paid_interest == false)
                                        {{ trans("mortgages.has_paid_all") }}
                                @endif
                            </td>
                        </tr>
                    @endforeach
                @else
                    <tr>
                        <td colspan="6">No Result...</td>
                    </tr>
                @endif
                </tbody>
            </table>
            <strong>{{ trans("mortgages.print_note") }}:</strong> {{ get_config("mortgage_note") }}
        </div>
    </div>
</div>
@if (get_config('auto_close_print') == 'yes')
    <script>
        window.close();
    </script>
@endif
</body>
</html>
