@extends('layouts.production')
@section('addCss')
    <style media="screen">
        table td { vertical-align: middle !important; }
    </style>
@endsection
@section('content')
    <section class="content-header">
        <h1>
            {{Trans("mortgages.menu")}}
            <small>{{ trans('dashboard.others.show_all') }}</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="/"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="{{ Route('mortgages.index') }}"><i class="fa fa-credit-card"></i> {{ Trans('mortgages.menu')}}</a></li>
            <li class="active">{{Trans("dashboard.others.show_all")}}</li>
        </ol>
    </section>
    <!-- Main content -->

    <section class="content">
        @include('layouts.includes.message')
        <div class="row">
            <div class="col-md-12">
                <div class="box box-info">
                    <div class="box-header with-border">
                        <div class="row">
                            {{ Form::open(['method' => 'get']) }}
                            <div class="col-md-4">
                                <div class="form-group">
                                    <?php
                                    $value = Request::get('invoice_id') ? Request::get('invoice_id') : null;

                                    ?>
                                    {{ Form::label('invoice_id', trans('invoices.id')) }}
                                    {{ Form::text('invoice_id', $value, [
                                      'class' => 'form-control',
                                      'placeholder' =>  trans('invoices.id')
                                    ]) }}
                                </div>
                                <div class="form-group">
                                    <?php
                                    $value = Request::get('name') ? Request::get('name') : null;

                                    ?>
                                    {{ Form::label('name', trans('customers.menu')) }}
                                    {{ Form::text('name', $value, [
                                      'class' => 'form-control',
                                      'placeholder' =>  trans('customers.menu')
                                    ]) }}
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    {{ Form::label('start_date', trans('invoices.start_date')) }}
                                    <div class="input-group date" data-provide="datepicker">
                                        <?php
                                        $value = Request::get('start_date') ? Request::get('start_date') : null;

                                        ?>

                                        {{ Form::text('start_date', $value, [
                                          'class' => "form-control",
                                          'placeholder' => Trans('invoices.start_date'),
                                          'autocomplete' => "off"
                                        ]) }}
                                        <div class="input-group-addon">
                                            <i class="fa fa-calendar"></i>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    {{ Form::label('end_date', trans('invoices.end_date')) }}
                                    <div class="input-group date" data-provide="datepicker">
                                        <?php
                                        $value = Request::get('end_date') ? Request::get('end_date') : null;

                                        ?>

                                        {{ Form::text('end_date', $value, [
                                          'class' => "form-control",
                                          'placeholder' => Trans('invoices.end_date'),
                                          'autocomplete' => "off"
                                        ]) }}
                                        <div class="input-group-addon">
                                            <i class="fa fa-calendar"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="">{{ trans("reports.show") }}</label>
                                    <?php
                                    $selected = Input::get('paginate') ? Input::get('paginate') : 10;
                                    ?>
                                    {{ Form::select("paginate", [
                                        'all'   =>  "All",
                                        10      =>  10,
                                        15      =>  15,
                                        20      =>  20,
                                        25      =>  25,
                                        30      =>  30,
                                        50      =>  50,
                                        100     => 100
                                    ], $selected, [
                                        'class' => 'form-control select2',
                                      ]) }}
                                </div>
                                <div class="form-group">
                                    <?php $selelcted = !empty(Input::get("status")) ? Input::get("status") : null; ?>
                                    <label for="status">{{ trans("installments.loan_status") }}</label>
                                    {{ Form::select("status", [
                                      'all'       =>  "All",
                                      'pendding'  =>  trans("mortgages.pendding"),
                                      'progressing'     =>  trans("mortgages.progressing"),
                                      'completed'      => trans("mortgages.completed"),
                                      'is_expired' => trans("mortgages.expired")
                                    ], $selelcted, [
                                      'class' => "form-control select2"
                                    ])}}
                                </div>
                                <button type="submit" class="btn btn-info pull-right" name="search" value="true"><i class="fa fa-search"></i> {{ Trans('invoices.search') }}</button>
                            </div>
                            {{ Form::close() }}
                        </div>
                    </div>
                    <div class="box-body">
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped">
                                <thead>
                                <tr>
                                    <th>{{ trans('mortgages.id') }}</th>
                                    <th>{{ trans('mortgages.date') }}</th>
                                    <th>{{ trans('mortgages.customer') }}</th>
                                    <th>{{ trans('mortgages.product_name')}}</th>
                                    <th>{{ trans('mortgages.price_out') }}</th>
                                    <th>{{ trans('dashboard.others.status') }}</th>
                                    <th>{{ trans('dashboard.crud.actions') }}</th>
                                </tr>
                                </thead>
                                <tbody>
                                @if (count($mortgages) > 0)
                                    @foreach($mortgages as $mortgage)
                                        <tr>
                                            <td>{{ convertInvoiceNumber($mortgage->id) }}</td>
                                            <td>{{ format_date_installment($mortgage->start_date) }}</td>
                                            <td>{{ $mortgage->fullname }} ({{ $mortgage->tel }})</td>
                                            <td>
                                                {{ $mortgage->product_name }}
                                                @if ($mortgage->is_expired)
                                                    <span class="label label-danger">{{ trans("mortgages.expired") }}</span>
                                                @endif
                                            </td>
                                            <td>{{ money($mortgage->price_out) }}</td>
                                            <td>
                                                @if ($mortgage->status == "pendding")
                                                    <span class="label label-warning">{{ trans("mortgages.".$mortgage->status) }}</span>
                                                @elseif ($mortgage->status == "progressing")
                                                    <span class="label label-info">{{ trans("mortgages.".$mortgage->status) }}</span>
                                                @else
                                                    <span class="label label-success">{{ trans("mortgages.".$mortgage->status) }}</span>
                                                @endif
                                            </td>
                                            <td>
                                                <a href="{{ route('mortgages.show', $mortgage->id) }}" class="btn btn-sm btn-default"><i class="fa fa-th-list"></i></a>
                                                @if (get_config('allow_delete_mortgage_completed') == "yes" || $mortgage->status != "completed")
                                                <a href="#" class="btn btn-sm btn-danger" data-toggle="modal" data-target="#myModal{{$mortgage->id}}"><i class="fa fa-trash"></i></a>
                                                @include('layouts.includes.modals.danger', ['model' => $mortgage,'toRoute'=>'mortgages','attribute'=>'product_name'])
                                                @endif
                                            </td>
                                        </tr>
                                    @endforeach
                                @else
                                    <tr>
                                        <td colspan="7" class="text-center">No record.........</td>
                                    </tr>
                                @endif
                                </tbody>
                            </table>
                        </div>
                        @if (empty(Input::get("paginate")) || Input::get("paginate") != "all")
                            <div class="row">
                                <div class="col-md-4">
                                    <p style="margin-top: 10px;">Total Records : {{ $mortgages->getTotal() }} Page {{ $mortgages->getCurrentPage() }} of {{ $mortgages->getLastPage() }}</p>
                                </div>
                                <div class="col-md-8 text-right">
                                    {{ $mortgages->appends(Request::except('page'))->links() }}
                                </div>
                            </div>
                        @else
                            @if ($mortgages->count() > 0)
                                Total Records : {{ $mortgages->count() }}
                            @endif
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
@section('addJs')
    {{ HTML::script('plugins/datepicker/bootstrap-datepicker.js') }}
    {{ HTML::script('plugins/datepicker/locales/bootstrap-datepicker.kh.js') }}
@endsection
