<table class="table table-bordered table-striped">
    <thead>
    <tr>
        <th style="width: 5%;">{{ trans('dashboard.id') }}</th>
        <th>{{ trans("mortgages.payment_date") }}</th>
        <th>{{ trans("mortgages.amount") }}</th>
        <th>{{ trans('mortgages.principal') }}</th>
        <th>{{ trans("mortgages.interest") }}</th>
        <th style="width: 20%;">{{ trans("dashboard.crud.actions") }}</th>
    </tr>
    </thead>
    <tbody>
    @if (count($payments) > 0)
        <?php $i = 1; ?>
        @foreach($payments as $payment)
            <tr>
                <td>{{ $i }}</td>
                <td>{{ format_date_installment($payment->payment_date) }}</td>
                <td>{{ money($payment->amount) }}</td>
                <td>{{ money($payment->principal) }}</td>
                <td>
                    @if ($payment->is_paid_interest)
                        <span class="label label-danger">{{ money($payment->interest) }}</span>
                    @else
                        {{ money($payment->interest) }}
                    @endif
                </td>
                <td>
                    @if ($payment->is_paid == false && $mortgage->status != "completed")
                        <a href="{{ route('mortgages.formPaidInterest', $payment->id) }}" class="btn btn-sm btn-primary btn-show-modal" data-title="{{ trans('mortgages.paid_interest') }}"><i class="fa fa-usd"></i> {{ trans("mortgages.paid_interest") }}</a>
                        <a href="{{ route('mortgage_payments.formPayment', $payment->id) }}" class="btn btn-sm btn-warning btn-show-modal" data-title="{{ trans("mortgages.total_payment") }}"><i class="fa fa-money"></i> {{ trans("mortgages.total_payment") }}</a>
                        <?php
                        $endDate = new \Carbon\Carbon($payment->payment_date);
                        $now = \Carbon\Carbon::now();
                        ?>
                        @if($now > $endDate)
                            <a href="{{ route('mortgage_payments.no_return', $payment->id) }}" class="btn btn-sm btn-danger btn-no-return"><i class="fa fa-check-circle-o"></i>{{ trans("mortgages.no_return") }}</a>
                        @endif
                    @else
                        @if ($mortgage->is_expired == false)
                            <a href="{{ route('mortgage_payments.history', $payment->id) }}" class="btn btn-sm btn-success btn-payment-history" data-title="{{ trans('mortgages.payment_history') }}"><i class="fa fa-history"></i></a>
                        @else
                            <span class="label label-danger">{{ trans('mortgages.expired') }}</span>
                        @endif
                    @endif
                </td>
            </tr>
            <?php $i++ ?>
        @endforeach
    @else
        <tr>
            <td colspan="6">No Result...</td>
        </tr>
    @endif
    </tbody>
</table>