@extends('layouts.production')
@section('addCss')
    <style media="screen">
        #example2_filter input[type=search] {
            width: 200px;
        }
        table td { vertical-align: middle !important; }
        fieldset {
            border: 1px solid #ddd !important;
            padding: 10px;
            margin-bottom: 20px;
        }
        legend { font-size: 14px; border-bottom: 0; width: inherit; border: 1px solid #ddd; padding: 10px; margin-bottom: 0;}
    </style>
@endsection
@section('content')
    <section class="content-header">
        <h1>
            {{Trans("mortgages.menu")}}
            <small>{{ $mortgage->exists ? trans('mortgages.edit') : trans('mortgages.add_new') }}</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="/"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="{{ Route('mortgages.index') }}"><i class="fa fa-credit-card"></i> {{ Trans('mortgages.menu')}}</a></li>
            <li class="active">{{Trans("dashboard.crud.add")}}</li>
        </ol>
    </section>
    <!-- Main content -->

    <section class="content">
        @include('layouts.includes.message')
        <div class="row">
            <div class="col-md-12">
                <div class="box box-info">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-credit-card"></i> {{ $mortgage->exists ? trans("mortgages.form_edit") : trans("mortgages.form") }}</h3>
                        @if($mortgage->exists)
                            <a href="{{ route('mortgages.show', $mortgage->id) }}" class="btn btn-sm btn-default pull-right"><i class="fa fa-th-list"></i> {{ trans("dashboard.others.show") }}</a>
                        @endif
                    </div>
                    <div class="box-body">
                        {{ Form::model($mortgage, [
                            'method' => $mortgage->exists ? 'put' : 'post',
                            'route' => $mortgage->exists ? ['mortgages.update', $mortgage->id] : 'mortgages.store',
                            'files' => true
                        ]) }}
                        <fieldset>
                            <legend><i class="fa fa-user-plus"></i> {{ trans("mortgages.customer_info") }}</legend>
                            <div class="row">
                                <div class="form-group col-md-4 {{ $errors->has('fullname') ? ' has-error' : '' }}">
                                    {{ Form::label("fullname", trans("mortgages.fullname")) }} <span class="required">*</span>
                                    {{ Form::text("fullname", null, [
                                        'class' => 'form-control',
                                        'placeholder' => trans("mortgages.fullname")
                                    ]) }}
                                    @if(isset($errors))
                                        <small class="text-danger">{{ $errors->first('fullname') }}</small>
                                    @endif
                                </div>
                                <div class="form-group col-md-4 {{ $errors->has('tel') ? ' has-error' : '' }}">
                                    {{ Form::label("tel", trans("mortgages.tel")) }} <span class="required">*</span>
                                    {{ Form::text("tel", null, [
                                        'class' => 'form-control',
                                        'placeholder' => trans("mortgages.tel")
                                    ]) }}
                                    @if(isset($errors))
                                        <small class="text-danger">{{ $errors->first('tel') }}</small>
                                    @endif
                                </div>
                                <div class="form-group col-md-4 {{ $errors->has('id_card') ? ' has-error' : '' }}">
                                    {{ Form::label("id_card", trans("mortgages.id_card")) }} <span class="required">*</span>
                                    {{ Form::text("id_card", null, [
                                        'class' => 'form-control',
                                        'placeholder' => trans("mortgages.id_card")
                                    ]) }}
                                    @if(isset($errors))
                                        <small class="text-danger">{{ $errors->first('id_card') }}</small>
                                    @endif
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12 form-group">
                                    {{ Form::label("address", trans("mortgages.address")) }}
                                    {{ Form::textarea("address", null, [
                                        'class' => 'form-control',
                                        'placeholder' => trans('mortgages.address'),
                                        'rows' => 2
                                    ]) }}
                                </div>
                            </div>
                        </fieldset>
                        <fieldset>
                            <legend><i class="fa fa-mobile"></i> {{ trans("mortgages.product_info") }}</legend>
                            <div class="row">
                                <div class="form-group col-md-4 {{ $errors->has('product_name') ? ' has-error' : '' }}">
                                    {{ Form::label("product_name", trans("mortgages.product_name")) }} <span class="required">*</span>
                                    {{ Form::text("product_name", null, [
                                        'class' => 'form-control',
                                        'placeholder' => trans("mortgages.product_name")
                                    ]) }}
                                    @if(isset($errors))
                                        <small class="text-danger">{{ $errors->first('product_name') }}</small>
                                    @endif
                                </div>
                                <div class="form-group col-md-4 {{ $errors->has('product_id') ? ' has-error' : '' }}">
                                    {{ Form::label("product_id", trans("mortgages.product_id")) }} <span class="required">*</span>
                                    {{ Form::text("product_id", null, [
                                        'class' => 'form-control',
                                        'placeholder' => trans("mortgages.product_id")
                                    ]) }}
                                    @if(isset($errors))
                                        <small class="text-danger">{{ $errors->first('product_id') }}</small>
                                    @endif
                                </div>
                                @if ($mortgage->exists == false)
                                <div class="form-group col-md-4">
                                    {{ Form::label("photo", trans("mortgages.photo")) }}
                                    {{ Form::file("photo[]", ['accept'=>"image/*",'capture'=>'camera',
                                        'class' => "form-control",
                                        'multiple' => true
                                    ]) }}
                                </div>
                                @endif
                            </div>
                            <div class="row">
                                <div class="form-group col-md-4 {{ $errors->has('price') ? ' has-error' : '' }}">
                                    {{ Form::label("price", trans("mortgages.price")) }} <span class="required">*</span>
                                    {{ Form::text("price", null, [
                                        'class' => 'form-control',
                                        'placeholder' => trans("mortgages.price")
                                    ]) }}
                                    @if(isset($errors))
                                        <small class="text-danger">{{ $errors->first('price') }}</small>
                                    @endif
                                </div>
                                <div class="form-group col-md-4 {{ $errors->has('price_out') ? ' has-error' : '' }}">
                                    {{ Form::label("price_out", trans("mortgages.price_out")) }} <span class="required">*</span>
                                    {{ Form::text("price_out", null, [
                                        'class' => 'form-control',
                                        'placeholder' => trans("mortgages.price_out")
                                    ]) }}
                                    @if(isset($errors))
                                        <small class="text-danger">{{ $errors->first('price_out') }}</small>
                                    @endif
                                </div>
                                <div class="form-group col-md-4 {{ $errors->has('rate') ? ' has-error' : '' }}">
                                    {{ Form::label("rate", trans("mortgages.rate")) }}  <span class="required">*</span>
                                    <?php $rate = get_config('mortgage_rate') ? get_config('mortgage_rate') : null; ?>
                                    {{ Form::text("rate", $rate, [
                                        'class' => 'form-control',
                                        'placeholder' => trans("mortgages.rate")
                                    ]) }}
                                    @if(isset($errors))
                                        <small class="text-danger">{{ $errors->first('rate') }}</small>
                                    @endif
                                </div>
                            </div>
                            <div class="row">
                                <div class="form-group col-md-4 {{ $errors->has('start_date') ? ' has-error' : '' }}">
                                    {{ Form::label("start_date", trans("mortgages.start_date")) }} <span class="required">*</span>
                                    <?php
                                    $selected = $mortgage->exists ? d_format($mortgage->start_date) : null;
                                    ?>
                                    <div class="input-group date">
                                        {{ Form::text("start_date", $selected, [
                                            'class' => 'form-control',
                                            'placeholder' => trans("mortgages.start_date"),
                                            'id' => 'start_date'
                                        ]) }}
                                        <div class="input-group-addon">
                                            <i class="fa fa-calendar-o"></i>
                                        </div>
                                    </div>
                                    @if(isset($errors))
                                        <small class="text-danger">{{ $errors->first('start_date') }}</small>
                                    @endif
                                </div>
                                <div class="form-group col-md-4 {{ $errors->has('end_date') ? ' has-error' : '' }}">
                                    {{ Form::label("end_date", trans("mortgages.end_date")) }} <span class="required">*</span>
                                    <?php
                                    $selected = $mortgage->exists ? d_format($mortgage->end_date) : null;
                                    ?>
                                    <div class="input-group date">
                                        {{ Form::text("end_date", $selected, [
                                            'class' => 'form-control',
                                            'placeholder' => trans("mortgages.end_date"),
                                            'id' => 'end_date'
                                        ]) }}
                                        <div class="input-group-addon">
                                            <i class="fa fa-calendar-o"></i>
                                        </div>
                                    </div>
                                    @if(isset($errors))
                                        <small class="text-danger">{{ $errors->first('end_date') }}</small>
                                    @endif
                                </div>
                                <div class="form-group col-md-4">
                                    {{ Form::label("note", trans("mortgages.note")) }}
                                    {{ Form::textarea("note", null, [
                                        'class' => 'form-control',
                                        'rows' => 2,
                                        'placeholder' => trans("mortgages.note")
                                    ]) }}
                                </div>
                            </div>
                        </fieldset>
                    </div>
                    <div class="box-footer">
                        <button type="submit" class="btn btn-success pull-right">{{ trans("mortgages.add_new") }}</button>
                        {{ Form::close() }}
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
@section('addJs')
    {{ HTML::script('plugins/datepicker/bootstrap-datepicker.js') }}
    {{ HTML::script('plugins/datepicker/locales/bootstrap-datepicker.kh.js') }}
    <script>
        $(function () {
           $("#start_date, #end_date").datepicker({
               format: "dd/mm/yyyy",
               todayHighlight: true,
               autoclose: true
           });
           @if ($mortgage->exists == false)
            $("#start_date").datepicker("setDate", "0");
           @endif
        });
    </script>
@endsection
