<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>{{ Config::get("app.app_name") }} | Log in</title>
    <!-- Tell the browser to be responsive to screen width -->
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <link rel="shortcut icon" href="{{ asset('favicon.png')}}">
    {{ HTML::style('production/css/default.css') }}
    <style>
        body {
            background-image: url("uploads/bg1.jpg");
            background-repeat: no-repeat;
            background-size: cover;
            background-position: center center;
            min-height: 100% !important;
        }
    </style>
    <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
    <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
    <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->
</head>
<body>
<div class="login-box">
    <div class="login-logo">
    </div>
    <!-- /.login-logo -->
    <div class="login-box-body">
        <div class="text-center">
            {{ HTML::image(imgUrl(get_config("company_logo")), "Logo",[
           'width' =>  "50%",
         ]) }}
            <hr>
            <h2><i class="fa fa-user"></i> {{ Trans('messages.login_form') }}</h2>
        </div>
        @if(Session::has('message') && Session::has('type'))
            <p class="text-center alert {{ Session::get('type') }}">
                {{ Trans(Session::get('message')) }}
            </p>
        @else
            <p class="login-box-msg">
                {{ Trans('messages.login_title') }}
            </p>
        @endif
        {{ Form::open() }}
        <div class="form-group has-feedback">
            {{ Form::text('username', null, [
              'class' => 'form-control',
              'placeholder' => Trans('messages.username')]) }}
            <span class="glyphicon glyphicon-envelope form-control-feedback"></span>
        </div>
        <div class="form-group has-feedback">
            {{ Form::password('password', [
              'class' => 'form-control',
              'placeholder' => Trans('messages.password')]) }}
            <span class="glyphicon glyphicon-lock form-control-feedback"></span>
        </div>

        <div class="row">
            <!-- /.col -->
            <div class="col-xs-12">
                <button type="submit" class="btn btn-primary btn-block btn-flat">{{Trans('messages.login')}}</button>
            </div>
            <!-- /.col -->
        </div>
        {{ Form::close() }}
    </div>
    <!-- /.login-box-body -->
</div>
<!-- /.login-box -->

</body>
</html>
