@extends('layouts.production')
@section('content')
  <section class="content-header">
    <h1>
      {{Trans("location.menu") }}
      <small>{{Trans("dashboard.crud.add")}} {{Trans("dashboard.crud.new")}}</small>
    </h1>
    <ol class="breadcrumb">
      <li><a href="/"><i class="fa fa-dashboard"></i> Home</a></li>
      <li><a href="/item_locations"><i class="fa fa-map"></i> {{ Trans('item_locations.menu')}}</a></li>
      <li class="active">{{Trans("dashboard.crud.add")}}</li>
    </ol>
  </section>

  <!-- Main content -->

  <section class="content">
    @include('layouts.includes.message')
    <div class="row">
        <div class="col-md-4">
            <div class="box">
                <div class="box-body">
                  {{ Form::model($location,[
                      'route' => $location->exists ? ['locations.update', $location->id] : 'locations.store',
                      'method' =>   $location->exists ? 'PUT' : 'POST'

                  ]) }}
                      <div class="form-group{{ $errors->has('name') ? ' has-error' : '' }}">
                          {{ Form::label('name', trans('location.location')) }}
                          {{ Form::text('name', null, ['class' => 'form-control', 'placeholder' => trans('location.location'), 'required' => 'required']) }}
                          <small class="text-danger">{{ $errors->first('name') }}</small>
                      </div>
                      <div class="form-group{{ $errors->has('amount') ? ' has-error' : '' }}">
                          {{ Form::label('floor_amount', trans('location.floor_amount')) }}
                          {{ Form::number('floor_amount', null, [
                              'class' => 'form-control',
                              'placeholder' =>  trans('location.floor_amount'),
                              'required' => 'required'
                          ]) }}
                          <small class="text-danger">{{ $errors->first('amount') }}</small>
                      </div>
                      <button type="submit" class="btn btn-success pull-right">{{ $location->exists ? trans('dashboard.crud.update') : trans('dashboard.crud.add') }}</button>
                  {{ Form::close() }}
                </div>
              </div>
        </div>
        <div class="col-md-8">
            <div class="box box-body">
                <table class="table table-border"
                 id="location-data">
                    <thead>
                        <tr>
                            <th>{{ trans('location.id') }}</th>
                            <th>{{ trans('location.location') }}</th>
                            <th>{{ trans('location.floor_amount') }}</th>
                            <th>{{ trans('dashboard.crud.actions') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @if (count($locations) > 0)
                        @foreach ($locations as $location)
                            <tr>
                                <td>{{ $location->id }}</td>
                                <td>{{ $location->name}}</td>
                                <td>{{ $location->floor_amount}}</td>
                                <td>
                                    <a href="{{ route('locations.edit', $location->id) }}" class="btn btn-xs btn-info"><i class="fa fa-edit">{{ trans('dashboard.crud.edit') }}</i></a>
                                    <a href="{{ route('locations.floors', $location->id) }}" class="btn btn-xs btn-default"><i class="fa fa-th-list"></i> {{ Trans('dashboard.others.show') }}</a></td>
                            </tr>
                        @endforeach

                        @endif
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    {{ Form::close() }}
  </section>
@endsection
@section('addJs')
    <script>
    $(function() {
        $('#location-data').dataTable({});
    });
    </script>
@endsection
