@extends('layouts.production')
@section('addCss')
    <style media="screen">
        table tr td {
            vertical-align: middle !important;
        }
        #box_amount {
            width: 20%;
        }
        .list-group-item:first-child {
            border-top: 0;
            border-radius: 0;
        }
        .list-group-item:last-child {
            border-bottom: 0;
            border-radius: 0;
        }
        .list-group-item {
            border-left: 0;
            border-right: 0;
        }
        .modal-box .modal-body {
            max-height: 500px;
	    	overflow-y: scroll;
        }
    </style>
@endsection
@section('content')
  <section class="content-header">
    <h1>
      {{Trans("location.menu")}}
      <small>{{ $location->name }}</small>
    </h1>
    <ol class="breadcrumb">
      <li><a href="/"><i class="fa fa-dashboard"></i> Home</a></li>
      <li><a href="/item_locations"><i class="fa fa-map"></i> {{ Trans('item_locations.menu')}}</a></li>
      <li class="active">{{Trans("dashboard.crud.add")}}</li>
    </ol>
  </section>

  <!-- Main content -->

  <section class="content">
    @include('layouts.includes.message')
    <div class="box">
        <div class="box-body">
          <table class="table table-bordered">
              <thead>
                  <tr>
                      <th>{{ trans('location.id')}}</th>
                      <th>{{ trans('location.floor') }}</th>
                      <th>{{ trans('location.box_amount') }}</th>
                      <th style="width:20%">{{ trans('dashboard.crud.actions') }}</th>
                  </tr>
              </thead>
              <tbody>
                  @if (count($floors) > 0)
                      @foreach ($floors as $floor)
                          <tr>
                              <td>{{ $floor->id }}</td>
                              <td>{{ $floor->name }}</td>
                              {{ Form::open(['route' => "floors.box_amount"]) }}
                              {{ Form::hidden('name', $floor->name) }}
                              {{ Form::hidden('floor_id', $floor->id) }}
                              <td><input type="number" name="box_amount" value="{{ $floor->box_amount}}" class="form-control" id="box_amount" required="required"></td>
                              <td>
                                  <button type="submit" class="btn btn-sm btn-info">{{ trans('dashboard.crud.update') }}</button>
                                  <a href="#" class="btn btn-sm btn-default" data-toggle="modal" data-target="#floor-{{$floor->id}}">{{ trans('location.show_boxes') }}</a>
                              {{ Form::close() }}
                              </td>
                          </tr>
                          <div class="modal fade modal-box" tabindex="-1" role="dialog" id="floor-{{$floor->id}}">
                          <div class="modal-dialog" role="document">
                            <div class="modal-content">
                              <div class="modal-header">
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                <h4 class="modal-title">{{ $floor->name }}</h4>
                              </div>
                              <div class="modal-body">
                                  <ul class="list-group">
                                      @if (count($floor->boxes) > 0)
                                          @foreach ($floor->boxes as $box)
                                              <li class="list-group-item">{{ $box->name }}</li>
                                          @endforeach
                                      @else
                                          <li class="list-group-item">No Box</li>
                                      @endif
                                  </ul>
                              </div>
                            </div><!-- /.modal-content -->
                          </div><!-- /.modal-dialog -->
                        </div><!-- /.modal -->
                      @endforeach
                  @else
                      <tr>
                          <td colspan="4">
                              No Floor
                          </td>
                      </tr>
                 @endif

              </tbody>
          </table>
        </div>
      </div>
    {{ Form::close() }}
  </section>
@endsection
