@extends('layouts.production')
@section("addCss")
<style media="screen">
    @media (min-width: 768px){
            .table-responsive {
            overflow-x: hidden;
        }
    }
   
</style>
@endsection
@section('content')
<section class="content-header">
    <h1>
        {{ Trans('customers.menu') }}
        <small>{{ Trans('customers.show') }}</small>
    </h1>
    <ol class="breadcrumb">
        <li><a href="/"><i class="fa fa-dashboard"></i> {{ Trans('dashboard.home') }}</a></li>
        <li><a href="{{ Route('loan_customers.index') }}"><i class="fa fa-user-plus"></i> {{ Trans('customers.menu') }}</a></li>
        <li class="active">{{ Trans('customers.show') }}</li>
    </ol>
</section>
<!-- Main content -->
<section class="content">
    @include('layouts.includes.message')
    <div class="row">
        <div class="col-md-12">
            <div class="box">
                <div class="box-header with-border">
                    <h3 class="box-title">{{ trans("customers.menu") }}</h3>
                </div>
                <!-- /.box-header -->
                <div class="box-body">
                    <div class="table-responsive">
                    <table id="example1" class="table table-bordered table-striped">
                        <thead>
                            <tr>
                                <th>{{ trans('customers.id') }}</th>
                                <th>{{ trans('customers.full_name_kh') }}</th>
                                <th>{{ trans('customers.full_name_en') }}</th>
                                <th>{{ trans('customers.sex') }}</th>
                                <th>{{ trans('customers.tel') }}</th>
                                <th style="width: 20%;">{{ trans('dashboard.crud.actions') }}</th>
                            </tr>
                        </thead>
                    </table>
                </div>
                </div>
            </div>
      <!-- /.box -->
        </div>
    </div>
</section>
@endsection
@section('addJs')
<script>
    $(function () {
        var dataTable = $("#example1").DataTable({
            "ajax"        : "{{Route('getLoanCustomers')}}",
            "processing"  : true,
            "serverSide"  : true,
            "paging": true,
            "autoWidth": false,
            "columnDefs": [
                { "searchable": false, "targets": 5 }
            ],
            "columns": [
                {data: 'id', name: 'id', orderable: false},
                {data: 'full_name_kh', name: 'full_name_kh',orderable: false},
                {data: 'full_name_en', name: 'full_name_en',orderable: false},
                {data: 'gender', name: 'gender',orderable: false,},
                {data: 'tel', name: 'tel',orderable: false,},
                {data: 'action', name: 'action',orderable: false}

            ],
            initComplete: function () {
                this.api().columns([1,2,3]).every(function () {
                var column = this;
                var input = document.createElement("input");
                $(input).appendTo($(column.footer()).empty())
                .on('change', function () {
                    var val = $.fn.dataTable.util.escapeRegex($(this).val());
                    column.search(val ? val : '', true, false).draw();
                });
            });
        }
    });
    $(document).on('click', '.btn-ajax-delete', function(e) {
        e.preventDefault();
        var btn = $(this);
        var url = btn.data('url');
        $.ajax({
            type: 'DELETE',
            url: url, 
            success: function (data) {
                if (data.error) {
                    $(".modal-delete").modal('hide');
                    sweetAlert("ជូនដំណឹង", data.message, "warning");
                } else {
                    dataTable.ajax.reload();
                    $(".modal-delete").modal('hide');
                    sweetAlert("ជូនដំណឹង", data.message, "success");
                }
            }
        });
      });
    });
  </script>
@endsection
