<div class="row">
	<div class="col-md-12">
	    <a href="{{ route('emiloans.create') }}" class="btn btn-info pull-right btn-show-installment-modal" data-type="add" data-title="EMI Loan"><i class="fa fa-plus" ></i> EMI Loan</a>
	</div>
</div>
<hr>
<div class="table-responsive">
	<table class="table table-bordered table-striped">
	<thead>
		<tr>
			<th>{{ trans("installments.id") }}</th>
			<th>{{ trans("installments.code") }}</th>
			<th>{{ trans('installments.date') }}</th>
			<th>{{ trans('installments.product_name') }}</th>
			<th>{{ trans('installments.total_price') }}</th>
			<th style="width: 20%;">{{ trans('dashboard.crud.actions') }}</th>
		</tr>
	</thead>
	@if (count($installments) > 0)
		<?php $i = 1; ?>
		@foreach($installments as $installment)
		<tr>
			<td>{{ $i }}</td>
			<td>{{ convertInvoiceNumber($installment->id)}}</td>
			<td>{{ $installment->displayDate() }}</td>
			<td>{{ $installment->product_name }}</td>
			<td>{{ money($installment->total_price) }}</td>
			<td>
				<a href="{{ route('emiloans.show', $installment->id)}}" class="btn btn-sm btn-default"><i class="fa fa-th-list"></i> {{ trans('dashboard.others.show') }}</a>				
				@if ($installment->status == "pendding")
				<a href="{{ route('emiloans.edit', $installment->id)}}" class="btn btn-sm btn-success btn-show-installment-modal" data-type="edit" data-title="EMI Loan"><i class="fa fa-edit"></i> {{ trans('dashboard.crud.edit') }}</a>
				<a href="{{ route('installments.destroy', ['id' => $installment->id]) }}" class="btn btn-sm btn-danger btn-delete-installment" data-name="{{ $installment->product_name }}" data-msg="{{ trans('messages.confirm_delete', ['attribute' => $installment->product_name])}}" data-yes="{{ trans('dashboard.others.yes')}}" data-no="{{ trans('dashboard.others.no') }}" data-deleted="{{ trans('dashboard.others.deleted') }}"><i class="fa fa-trash-o"></i> {{ trans('dashboard.crud.remove') }}</a>				

				@endif

			</td>
		</tr>
		<?php $i++;?>
		@endforeach
	@else
		<tr>
			<td colspan="6">No result...</td>
		</tr>
	@endif
	<tbody>
	</tbody>
</table>
</div>