{{ Form::model($installment, [
    'route' => $installment->exists ? ['emiloans.update', $installment->id] : 'emiloans.store',
    'method'    =>  $installment->exists ? "PUT" : "POST"
]) }}
<div class="row">
    <div class="col-md-6 form-group">
        {{ Form::label("type_of_product", trans('installments.type_of_product')) }} <span class="required">*</span>
        {{ Form::text("type_of_product", null, [
            'class' => 'form-control',
            'placeholder'   =>  trans('installments.type_of_product'),
            'required' => "required"
        ]) }}
    </div>
    <div class="col-md-6 form-group">
        {{ Form::label("product_name", trans('installments.product_name')) }}  <span class="required">*</span>
        {{ Form::text("product_name", null, [
            'class' => 'form-control',
            'placeholder'   =>  trans('installments.product_name'),
            'required' => "required"
        ]) }}
    </div>
</div>
<div class="row">
    <div class="col-md-6 form-group">
        {{ Form::label("model", trans('installments.model')) }}  <span class="required">*</span>
        {{ Form::text("model", null, [
            'class' => 'form-control',
            'placeholder'   =>  trans('installments.model'),
            'required' => "required"
        ]) }}
    </div>
    <div class="col-md-6 form-group">
        {{ Form::label("imie", trans('installments.imie')) }}  <span class="required">*</span>
        {{ Form::text("imie", null, [
            'class' => 'form-control',
            'placeholder'   =>  trans('installments.imie'),
            'required' => "required"
        ]) }}
    </div>
</div>
<div class="row">
    <div class="col-md-6 form-group">
        {{ Form::label("total_price", trans('installments.price')) }}  <span class="required">*</span>
        {{ Form::number("total_price", null, [
            'class' => 'form-control',
            'step'  =>  'any',
            'placeholder'   =>  trans('installments.price'),
        ]) }}
    </div>
    <div class="col-md-6 form-group">
        <?php $rate = $installment->exists ? $installment->rate : get_config("emi_rate") ?>
        {{ Form::label("rate", trans('installments.rate')) }} <span class="required">*</span> %
        {{ Form::number("rate", $rate, [
            'class' => 'form-control',
            'step'  =>  'any',
            'placeholder'   =>  trans('installments.rate'),
            'required' => "required"
        ]) }}
    </div>
</div>
<div class="row">
    <div class="col-md-6 form-group">
        {{ Form::label("duration", trans('installments.duration')) }}  <span class="required">*</span>
        {{ Form::number("duration", null, [
            'class' => 'form-control',
            'placeholder'   =>  trans('installments.duration'),
            'required' => "required"
        ]) }}
    </div>
    <div class="col-md-6 form-group">
        {{ Form::label("deposit", trans('installments.deposit')) }}
        {{ Form::number("deposit", null, [
            'class' => 'form-control',
            'step'  =>  'any',
            'placeholder'   =>  trans('installments.deposit')
        ]) }}
    </div>
</div>
<div class="row">
    <div class="col-md-12 form-group">
     {{ Form::label('in_date',Trans("installments.date_payment")) }}
     <div class="input-group date">
     <?php $selected =  $installment->in_date ? d_format($installment->in_date) : null; ?>
       {{ Form::text('in_date', $selected, [
           'class' => 'form-control',
           'id'    => "in_date",
           'placeholder'    =>  trans('installments.date_payment')
       ]) }}
       <div class="input-group-addon">
           <i class="fa fa-calendar-o"></i>
       </div>
     </div>
   </div>
</div>
<div class="row">
    <div class="col-md-12">
      {{ Form::label("note", trans('installments.note')) }}
        {{ Form::textarea("note", null, [
            'class' => 'form-control',
            'placeholder'   =>  trans('installments.note'),
            'rows'  =>  '2'
        ]) }}
    </div>
</div>
{{ Form::close() }}