<!DOCTYPE html>
	<html>
		<head>
			<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
			<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
			<title>POS Management | The Coder Studio </title>
			<meta name="description" content="">
			<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
			<!-- Favicons -->
			<link rel="apple-touch-icon-precomposed" sizes="144x144" href="assets/images/icons/apple-touch-icon-144-precomposed.png">
			<link rel="apple-touch-icon-precomposed" sizes="114x114" href="assets/images/icons/apple-touch-icon-114-precomposed.png">
			<link rel="apple-touch-icon-precomposed" sizes="72x72" href="assets/images/icons/apple-touch-icon-72-precomposed.png">
			<link rel="apple-touch-icon-precomposed" href="assets/images/icons/apple-touch-icon-57-precomposed.png">
			<link rel="shortcut icon" href="assets/images/icons/favicon.png">

			<!-- Bootstrap -->
			{{ HTML::style('assets/vendor/bootstrap/dist/css/bootstrap.min.css') }}
			{{ HTML::style('plugins/datatables/dataTables.bootstrap.css') }}
			<!-- Font Awesome -->
			{{ HTML::style('assets/vendor/font-awesome/css/font-awesome.min.css') }}
			<!-- Ionicons -->
			{{ HTML::style('assets/vendor/Ionicons/css/ionicons.min.css') }}
			{{ HTML::style("plugins/select2/select2.min.css") }}
			<!-- Custom scrollbar Stylesheet -->
			<!-- Sale Stylesheet -->
			{{ HTML::style('production/css/sale_v1.css') }}
			<!-- Toaster -->
			{{ HTML::style('assets/vendor/toastr/toastr.css')}}
			{{ HTML::style('assets/vendor/animate.css/animate.min.css')}}
			<!-->Calculator </!-->
			{{ HTML::style('assets/vendor/jQuery.NumPad/jquery.numpad.css')}}
			{{ HTML::style("assets/css/jquery-confirm.css") }}
			@yield('style')
		<style>
			{{ Helper::getConfig('custom_style') }}
		</style>
		@yield('addCss')
		</head>
		<body>
			<div class="container-fluid page-container sale-container sidebar-collapse">
				<!-- Sidebar-->
					<aside class="main-sidebar">
				  <!-- sidebar: style can be found in sidebar.less -->
				  <section class="sidebar-nav" style="height: auto;">
				    <!-- sidebar menu: : style can be found in sidebar.less -->
				    <h4>Quick Setting</h4>
				    <ul class="sidebar-menu">
				    <br/>
				      <li>
			      		<div>
			      			<input type="checkbox" name="price_type" id="price_type"><label for="price_type">{{ Trans('products.price_wholesale')}}</label>
			      		</div>
			      	</li>
			      	<li>
			      		<a href="{{route('dashboard')}}">Dashboard</a>
			      	</li>
				    </ul>
				  </section>
				  <!-- /.sidebar -->
				</aside>
				<!-- End Sidebar -->
				<!-- TOP NAVIGATION BAR -->
				<div class="row top-navbar">
					<div class="left-navbar float-left clearfix">
						<ul class="clearfix">
							<li class="trigger-sidebar">
								<a href="#"><i class="icon ion-navicon"></i></a>
							</li>
							<li id="product-tab" class="dropdown active">
								<a id="dLabel" data-target="#" href="#" data-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false">
									{{ Trans('products.product') }}
									@if (get_config('style_sale') == "list")
										<i class="icon ion-ios-arrow-down"></i>
									@endif
								 </a>
								@if (get_config('style_sale') == "list")
								<div class="dropdown-menu category-menu" aria-labelledby="dLabel">
									<div class="category-wrapper">
										<div class="category-heading">
											<p>{{ Trans('products.product_category') }}</p>
											<i class="icon ion-android-done"></i>
										</div>
										
										<ul>
											<li class="clearfix">
												<a href="{{route('sale')}}">
													<div class="category-img">
														<img src="" alt="" class="img-circle">
													</div>
													<div class="category-text">
														<div class="category-name">
															<p>{{ Trans('dashboard.others.show_all') }}</p>
														</div>
														<div class="category-item">
															@if(isset($category) && $category =="")
																<i class="icon ion-android-done"></i>
															@endif
														</div>
													</div>
												</a>
											</li>
											@foreach($categories as $productCategory)
											<li class="clearfix">
												<a href="{{route('sale',$productCategory->id)}}">
													<div class="category-img">
														<img src="{{$productCategory->icon}}" alt="" class="img-circle">
													</div>
													<div class="category-text">
														<div class="category-name">
															<p>{{ $productCategory->name }}</p>
														</div>
														<div class="category-item">
															@if(isset($category) && $category == $productCategory->id)
																<i class="icon ion-android-done"></i>
															@else
															{{ Helper::countItems("Products",$productCategory->id,'product_category_id')}}
															@endif
														</div>
													</div>
												</a>
											</li>
											@endforeach
										</ul>
									</div>
								</div>
							@endif
							</li>
							<li id="order-tab">
								<a href="#">Orders</a>
							</li>
						</ul> <!-- NAVIGATION -->
						<div class="barcode-input hidden-xs">
							{{ Form::open(array('method'=>'POST','files' => true,'class'=>'submit_sku')) }}
								{{ Form::text('barcode', '', array('placeholder'=>Trans('products.sku'),'class'=>'product_sku_n')) }}
								<input type="submit" name="submit" class="hidden">
							{{ Form::close() }}
						</div>
						@if (get_config('style_sale') == "list")
						<div class="search-product-wrapper">
							<div class="search-box hidden-xs hidden-sm">
                <?php
                $value = !empty(Input::get("q")) ? Input::get('q') : "";
                ?>
                {{ Form::open(array('method'=>'GET')) }}
  								{{ Form::text('q', $value, array('placeholder'=>Trans('dashboard.others.search'),'class'=>'form-control input-serach')) }}
  							{{ Form::close() }}
							</div>
						</div> <!-- SEARCH -->
						@endif
					</div>
					<div class="right-navbar float-right nav-cart clearfix hidden-xs">
						<div class="list-btn">
							<a href="#">
								<i class="icon ion-ios-list-outline"></i>
							</a>
						</div>
						<div class="cart-text">
								<?php
									if(isset($customer)){
										foreach ($customer as $key => $value) {
											echo "<p>#". convertInvoiceNumber($invoiceId) . " - " . $value . "</p>";
										}
									} else {
										echo 	"<p>#". convertInvoiceNumber($invoiceId) . "</p>";
									}
								?>


						</div>

						<div class="add-cart-btn">
								<a href="#" data-toggle="modal" data-target="#customerModal"><i class="icon ion-ios-plus-empty"></i></a>
						</div>
					</div> <!-- NAVIGATION CART -->
				</div><!-- END TOP NAVIGATION BAR-->
				@yield('content')
			</div>
		</body>
		{{ HTML::script('assets/vendor/jquery/dist/jquery.min.js') }}
		{{ HTML::script('assets/vendor/bootstrap/dist/js/bootstrap.min.js') }}
		{{ HTML::script("plugins/datatables/jquery.dataTables.min.js") }}
		{{ HTML::script('plugins/datatables/dataTables.bootstrap.js') }}
		<script>
			$(document).bind('keydown', function(e) {
            // console.log(e.keyCode);
            switch (e.keyCode) {
                case 118: //F7
                    window.location = "{{ route('dashboard') }}";
                    return false;
                    break;
            }
        });
			function updateClock ( )
  {
  var currentTime = new Date ( );
    var currentHours = currentTime.getHours ( );
    var currentMinutes = currentTime.getMinutes ( );
    var currentSeconds = currentTime.getSeconds ( );

    // Pad the minutes and seconds with leading zeros, if required
    currentMinutes = ( currentMinutes < 10 ? "0" : "" ) + currentMinutes;
    currentSeconds = ( currentSeconds < 10 ? "0" : "" ) + currentSeconds;

    // Choose either "AM" or "PM" as appropriate
    var timeOfDay = ( currentHours < 12 ) ? "ព្រឹក" : "ល្ងាច";

    // Convert the hours component to 12-hour format if needed
    currentHours = ( currentHours > 12 ) ? currentHours - 12 : currentHours;

    // Convert an hours component of "0" to "12"
    currentHours = ( currentHours == 0 ) ? 12 : currentHours;

    // Compose the string for display
    var currentTimeString = currentHours + ":" + currentMinutes + ":" + currentSeconds + " " + timeOfDay;
    
    
    $("#timer").text(currentTimeString);
        
 }
 $(document).ready(function()
{
   setInterval('updateClock()', 1000);
});
		</script>
		{{ HTML::script('assets/vendor/jquery-ui/jquery-ui.js') }}
		{{ HTML::script('assets/vendor/toastr/toastr.min.js')}}
		{{ HTML::script("plugins/select2/select2.full.min.js") }}
		{{ HTML::script('assets/vendor/jQuery.NumPad/jquery.numpad.js')}}
		{{ HTML::script('assets/js/min/jquery.mCustomScrollbar.concat.min.js') }}
		{{ HTML::script('assets/js/min/sale.min.js') }}
		{{ HTML::script('assets/js/min/script.min.js') }}
		{{ HTML::script('assets/js/jquery-confirm.js') }}
		@yield('addJs')
	</html>
