<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Report</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  {{ HTML::style('production/css/default.css') }}
  <style media="screen">
    .report-logo{ width: 100px;}
  </style>
  <style media="print">
    .report-logo{ width: 100px;}
    body{font-size: 12px;}
    {{ Helper::getConfig('custom_style') }}
  </style>
  @yield('style')
</head>
<body onload="window.print();">
<div class="wrapper">
  <!-- Main content -->
  <section class="invoice">
    <!-- title row -->
    <div class="row">
      <div class="col-xs-12">
        {{ HTML::image(Helper::getConfig('company_logo'), "Logo", ['class' => "report-logo"]) }}
        <h2 class="page-header">
          {{ Helper::getConfig('company_name') }}
          <small class="pull-right">{{ trans('reports.date') }} {{ date('d/m/Y') }}</small>
        </h2>
      </div>
      <!-- /.col -->
    </div>
    <!-- info row -->
    <div class="row invoice-info">
      @yield('header')
    </div>
    <!-- /.row -->

    <!-- Table row -->
    <div class="row">
      <div class="col-xs-12 table-responsive">
        @yield('table')
      </div>
      <!-- /.col -->
    </div>
    <!-- /.row -->
  </section>
  <!-- /.content -->
</div>
<!-- ./wrapper -->
</body>
</html>
