<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>{{ Config::get("app.app_title") }}</title>
    <!-- Tell the browser to be responsive to screen width -->
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <link rel="shortcut icon" href="{{ asset('favicon.png')}}">
    {{ HTML::style('production/css/default.css') }}

    {{ HTML::style('production/css/base.css') }}
    {{ HTML::style('css/sweetalert.css') }}
    <link href="https://fonts.googleapis.com/css?family=Chenla|Roboto:500" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css?family=Chenla|Metal" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css?family=Roboto" rel="stylesheet">
    <style media="screen">
        .required {
            color: red !important;
        }
        .text-danger { color: #dd4b39 !important; }
        body,.h1, .h2, .h3, .h4, .h5, .h6, h1, h2, h3, h4, h5, h6{
            font-family: 'Chenla', 'Roboto';
            <!-- font-family: 'Metal', cursive; -->
        }
    </style>
    @yield('addCss')
    <style>
        {{ Helper::getConfig('custom_style') }}
    </style>
    
</head>
<?php
$theme = (!empty(Helper::getConfig('custom_theme'))) ? Helper::getConfig('custom_theme') : "skin-green-light"; ?>
<body class="hold-transition {{$theme}} sidebar-mini sidebar-collapse">

<!-- Site wrapper -->
<div class="wrapper">
    <!-- Top Navigation bar -->
    @include('layouts.includes.navbar')
    <!-- =============================================== -->

    <!-- Left side column. contains the sidebar -->
    @include('layouts.includes.sidebar')
    <!-- =============================================== -->

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        @if (check_cloud_expired())
        <div class="alert alert-warning alert-dismissible" style="border-radius: 0; margin-bottom: 5px; text-align: center;" id="expired_date">
            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
            <h4><i class="icon fa fa-info-circle"></i> ការបង់ប្រាក់សំរាប់រក្សាទុក និងប្រើប្រាស់ប្រព័ន្ធគ្រប់គ្រងទិន្ន័យ របស់អ្នកលើអីុនធឺណេត មានសុភលភាពរហូតដល់ {{ get_config("cloud_expired_date") }}</h4>
            <p>សូមធ្វើការទំនាក់ទនងពួកយើងសំរាប់ការបង់ប្រាក់ <a href="tel:085888456"><i class="fa fa-phone"></i> 085 888 456</a>​ <a href="tel:098232378"><i class="fa fa-phone"></i> 098 23 23 78</a>​ សូមអគុណសំរាប់ការប្រើប្រាស់សេវាកម្មរបស់ពួកយើង!</p>
        </div>
        @endif
        @yield('content')
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->
    @include('layouts.includes.footer')

</div>

{{ HTML::script('production/js/app.js') }}
{{ HTML::script('js/sweetalert.min.js') }}

<script type="text/javascript">
    $(".select2").select2();
    $(document).bind('keydown', function(e) {
        // console.log(e.keyCode);
        switch (e.keyCode) {
            case 118: //F7
                window.location = "{{ route('sale') }}";
                return false;
                break;
        }
    });
    $("#expired_date").fadeTo(10000, 500).slideUp(1000, function () {
        $(this).hide();
    });
</script>
@yield('addJs')
</body>
</html>
