<header class="main-header">
  <!-- Logo -->
  <a href="#" class="logo">
    <!-- mini logo for sidebar mini 50x50 pixels -->
    <span class="logo-mini"><b>Loan</b></span>
    <!-- logo for regular state and mobile devices -->
    <span class="logo-lg"><b>{{ Config::get('app.app_name')  }}</b> V{{ Config::get('app.app_version') }}</span>
  </a>
  <!-- Header Navbar: style can be found in header.less -->
  <nav class="navbar navbar-static-top">
    <!-- Sidebar toggle button-->
    <a href="#" class="sidebar-toggle" data-toggle="offcanvas" role="button">
      <span class="sr-only">Toggle navigation</span>
      <span class="icon-bar"></span>
      <span class="icon-bar"></span>
      <span class="icon-bar"></span>
    </a>
    <div class="navbar-custom-menu">

      <ul class="nav navbar-nav">
        {{-- If Use can sale --}}
        @if(mort_before_payments()->count() > 0)
          <li>
            <a href="{{route('mortgage_payments.before')}}" title="{{ Trans('mortgages.before_payment') }}">
              <i class="fa fa-credit-card-alt"></i>
              <span class="label label-warning">{{ mort_before_payments()->count() }}</span>
            </a>
          </li>
        @endif
          @if(mort_today_payments()->count() > 0)
        <li>
          <a href="{{route('mortgage_payments.today')}}" title="{{ Trans('mortgages.today_payment') }}">
            <i class="fa fa-credit-card"></i>
            <span class="label label-success">{{ mort_today_payments()->count() }}</span>
          </a>
        </li>
          @endif
          @if(mort_late_payments()->count() > 0)
        <li>
          <a href="{{route('mortgage_payments.late')}}" title="{{ Trans('mortgages.late_payment') }}">
            <i class="fa fa-clock-o"></i>
            <span class="label label-danger">{{ mort_late_payments()->count() }}</span>
          </a>
        </li>
          @endif
        <!-- Notifications: style can be found in dropdown.less -->
        @if(count(get_min_amount()) > 0)
          <li>
            <a href="{{route('getProductMin')}}" title="{{ Trans('products.min_amount') }}">
              <i class="fa fa-flag-o"></i>
              <span class="label label-danger">{{ count(get_min_amount()) }}</span>
            </a>
          </li>
        @endif
        @if (cont_payment_today() > 0)
          <li>
            <a href="{{route('payments.today')}}" title="{{ Trans('payments.payment_today') }}">
              <i class="fa fa-calendar-check-o"></i>
              <span class="label label-danger">{{ cont_payment_today() }}</span>
            </a>
          </li>
        @endif
        <!-- Tasks: style can be found in dropdown.less -->
        <!-- User Account: style can be found in dropdown.less -->
        <li class="dropdown user user-menu">
          <a href="#" class="dropdown-toggle" data-toggle="dropdown">
            @if(!empty(Auth::user()->photo))
              <img src="{{ imgUrl(Auth::user()->photo) }}" class="user-image" alt="User Image">
            @endif
            <span class="hidden-xs">{{ Auth::user()->fullName() }}</span>
          </a>
          <ul class="dropdown-menu">
            <!-- User image -->
            <li class="user-header">
              @if(!empty(Auth::user()->photo))
                <img src="{{ imgUrl(Auth::user()->photo) }}" class="img-circle" alt="User Image">
              @endif
              <p>
                {{Auth::user()->first_name}}
                <small>Member since. {{formatDate(Auth::user()->created_at)}}</small>
              </p>
            </li>
            <!-- Menu Body -->
            <!-- Menu Footer-->
            <li class="user-footer">
              <div class="pull-right">
                {{ link_to_route('form.logout',Trans('messages.logout') ,null, ['class' => 'btn btn-default btn-flat']) }}
              </div>
            </li>
          </ul>
        </li>
      </ul>
    </div>
  </nav>
</header>
