@extends('layouts.production')
@section('content')
  <section class="content-header">
    <h1>
      {{Trans("item_locations.menu")}}
      <small>{{Trans("dashboard.crud.add")}} {{Trans("dashboard.crud.new")}}</small>
    </h1>
    <ol class="breadcrumb">
      <li><a href="/"><i class="fa fa-dashboard"></i> Home</a></li>
      <li><a href="/item_locations"><i class="fa fa-map"></i> {{ Trans('item_locations.menu')}}</a></li>
      <li class="active">{{Trans("dashboard.crud.add")}}</li>
    </ol>
  </section>

  <!-- Main content -->

  <section class="content">
    @include('layouts.includes.message')
    <div class="box">
        <div class="box-header with-border">
          <h3 class="box-title">{{ trans('dashboard.form')}} {{ trans('item_locations.menu')}}</h3>
        </div>
        <div class="box-body">
          <div class="row">
              <div class="col-md-4">
                  {{ Form::open(['url' => 'add']) }}
                      <div class="form-group{{ $errors->has('name') ? ' has-error' : '' }}">
                          {{ Form::label('name', 'Name') }}
                          {{ Form::text('name', null, ['class' => 'form-control', 'placeholder' => "Name"]) }}
                          <small class="text-danger">{{ $errors->first('name') }}</small>
                      </div>
                      <div class="form-group{{ $errors->has('amount') ? ' has-error' : '' }}">
                          {{ Form::label('amount', 'Amount') }}
                          {{ Form::number('amount', null, [
                              'class' => 'form-control',
                              'placeholder' =>  "Amount"
                          ]) }}
                          <small class="text-danger">{{ $errors->first('amount') }}</small>
                      </div>
                      <button type="submit" class="btn btn-sm btn-success">+ Add</button>
                  {{ Form::close() }}
              </div>
              <div class="col-md-8">
                  <table class="table">
                      <thead>
                          <tr>
                              <th>ID</th>
                              <th>Name</th>
                              <th>Action</th>
                          </tr>
                      </thead>
                      <tbody>
                          <tr>
                              <td>01</td>
                              <td>A01</td>
                              <td><a href="#" class="btn btn-sm btn-primary"><i class="fa fa-th-list"></i> Detail</a></td>
                          </tr>
                      </tbody>
                  </table>
              </div>
          </div>
        </div>
      </div>
    {{ Form::close() }}
  </section>
@endsection
