@extends('layouts.production')
@section('addCss')
<style media="screen">
  #example2_filter input[type=search] {
    width: 200px;
  }
</style>
@endsection
@section('content')
  <section class="content-header">
    <h1>
      {{ Trans('item_locations.menu') }}
      <small>{{ Trans('dashboard.others.show_all') }}</small>
    </h1>
    <ol class="breadcrumb">
      <li><a href="/"><i class="fa fa-dashboard"></i> Home</a></li>
      <li class="active">{{ Trans('item_locations.menu') }}</li>
    </ol>
  </section>
  <!-- Main content -->
  <section class="content">
    @include('layouts.includes.message')
    <?php
    $max_file_size = 10487560; // expressed in bytes
                              // 10240 = 10 KB
     ?>
    <div class="row">
        <div class="col-md-4">
                {{ Form::model($item_location, [
                    'route' => $item_location->exists ? ['item_locations.update', $item_location->id] : 'item_locations.store',
                    'method'=> $item_location->exists ? 'PUT' : 'POST',
                    'files' => true
               ]) }}
                <input type="hidden" name="MAX_FILE_SIZE" value="{{ $max_file_size }}">
                <div class="box">
                    <div class="box-header with-border">
                      <h3 class="box-title">{{ trans('dashboard.form')}} {{ trans('item_locations.menu')}}</h3>
                    </div>
                    <div class="box-body">
                        <div class="form-group">
                          {{ Form::label('name', Trans('item_locations.name')) }}
                          {{ Form::text('name', null, [
                            'class' => 'form-control',
                            'placeholder' => Trans('item_locations.name'),
                            'required'  => 'required'
                          ])}}
                        </div>
                        <div class="form-group">
                          {{ Form::label('picture', Trans('item_locations.picture')) }}
                          {{ Form::file('picture', [
                            'class' => 'form-control'
                          ])}}
                        </div>
                        <div class="form-group">
                          {{ Form::label('description', Trans('item_locations.description')) }}
                          {{ Form::textarea('description', null, [
                            'class' => 'form-control',
                            'placeholder' => Trans('item_locations.description'),
                            'rows' => '3'
                          ])}}
                       </div>
                       <div class="pull-right">
                           <button type="submit" class="btn btn-primary">{{ $item_location->exists ? trans('dashboard.crud.update') : trans('dashboard.crud.add') }}</button>
                       </div>
                  </div>
              </div>
                {{ Form::close() }}
        </div>
        <div class="col-md-8">
            <div class="box box-body">
              <table class="table table-bordered" id="example2">
                <thead>
                  <tr>
                    <th>{{ trans('location.id') }}</th>
                    <th>{{ Trans('item_locations.menu')}}</th>
                    @if(UserRole::has('edit_location') || UserRole::has('delete_location'))
                    <th>{{ Trans('dashboard.crud.actions')}}</th>
                    @endif
                  </tr>
                </thead>
                <tbody>
                  @foreach($item_locations as $item)
                    <tr>
                      <td>{{ $item->id }}</td>
                      <td>{{ $item->name }}</td>
                      @if(UserRole::has('edit_location') || UserRole::has('delete_location'))
                      <td>
                        @if(UserRole::has("edit_location"))
                          <a href="{{ Route("item_locations.edit",$item->id) }}" class="btn btn-xs btn-info">{{Trans("dashboard.crud.edit")}}</a>
                        @endif
                        @if(UserRole::has("delete_location"))
                          <a href="#" class="btn btn-xs btn-danger" data-toggle="modal" data-target="#myModal{{$item->id}}">{{Trans("dashboard.crud.remove")}}</a>
                        @endif
                        @include('layouts.includes.modals.danger', ['model' => $item,'toRoute'=>'item_locations','attribute'=>'name'])
                      </td>
                      @endif
                    </tr>
                  @endforeach
                </tbody>
              </table>
            </div>
        </div>
    </div>

  </section>
@endsection
@section('addJs')
<script>
  $(function () {
    $("#example1").DataTable();
    $('#example2').DataTable({
      "paging": true,
      "lengthChange": true,
      "searching": true,
      "ordering": true,
      "info": true,
      "autoWidth": false
    });
  });
</script>
@endsection
