@extends('layouts.production')
@section('content')
  <section class="content-header">
    <h1>
      {{Trans("item_locations.menu")}}
      <small>{{Trans("dashboard.crud.add")}} {{Trans("dashboard.crud.new")}}</small>
    </h1>
    <ol class="breadcrumb">
      <li><a href="/"><i class="fa fa-dashboard"></i> Home</a></li>
      <li><a href="/item_locations"><i class="fa fa-map"></i> {{ Trans('item_locations.menu')}}</a></li>
      <li class="active">{{Trans("dashboard.crud.add")}}</li>
    </ol>
  </section>

  <!-- Main content -->

  <section class="content">
    @include('layouts.includes.message')
    <?php
    $max_file_size = 10487560; // expressed in bytes
                              // 10240 = 10 KB
     ?>
    {{ Form::open(array('route' => 'item_locations.store','method'=>'POST','files' => true)) }}
    <input type="hidden" name="MAX_FILE_SIZE" value="{{ $max_file_size }}">
    <div class="box">
        <div class="box-header with-border">
          <h3 class="box-title">{{ trans('dashboard.form')}} {{ trans('item_locations.menu')}}</h3>
        </div>
        <div class="box-body">
          @include('itemLocations.inc.form')
        </div>
      </div>
    {{ Form::close() }}
  </section>
@endsection
