@extends('layouts.production')
@section('addCss')
<style media="screen">
    #example2_filter input[type=search] {
        width: 200px;
    }
    table td { vertical-align: middle !important; }
</style>
@endsection
@section('content')
<section class="content-header">
    <h1>
        {{Trans("installments.menu")}}
    </h1>
    <ol class="breadcrumb">
        <li><a href="/"><i class="fa fa-dashboard"></i> Home</a></li>
        <li><a href="{{ Route('installments.index') }}"><i class="fa fa-usd"></i> {{ Trans('debts.menu')}}</a></li>
        <li class="active">{{Trans("dashboard.crud.add")}}</li>
    </ol>
</section>

<!-- Main content -->

<section class="content">
    @include('layouts.includes.message')
    <div class="row">
        <div class="col-md-12">
            <div class="box">
                <div class="box-header with-border">
                    <h3 class="box-title">{{ trans('installments.detail') }} </h3>
                </div>
                <div class="box-body">
                    <table class="table table-bordered table-striped">
                        <tr>
                            <th>Total Price</th>
                            <td>{{ $installment->getTotalPrice() }}</td>
                        </tr>   
                        <tr>
                            <th>Total Payment</th>
                            <td>
                                {{ sprintf("%01.2f",$installment->futureValue()) }} {{ $installment->getPriciple() }}
                            </td>
                            <th>EMI</th>
                            <td>{{ sprintf("%01.2f",$installment->getEMIAmount()) }}</td>
                        </tr>
                        <tr>
                            <th>Rate </th>
                            <td>{{ $installment->rate }}</td>
                            <th>Flate Rate</th>
                            <td>{{ $installment->flatRate() }}</td>
                        </tr>
                        <tr>
                            <th>First Montth</th>
                            <td>{{ $installment->displayFirstMonth() }}</td>
                            <th>Next Month</th>
                            <td>{{ $installment->emiPayment() }}</td>
                        </tr>
                    </table>
                    <h3>Calculate And Revert it from flat rate {{ $installment->addInterest() }}</h3>
                    <table class="table table-striped table-bordered">
                        <thead>
                            <tr>
                                <th>Term</th>
                                <th>Date</th>
                                <th>EMI</th>
                                <th>Rate</th>
                                <th>Principle</th>
                                <th>Balance</th>
                                <th>Outstanding Debt</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $addRate = $installment->addInterest();
                            $loanAmount = $installment->getPriciple();
                            $remainAmount = $loanAmount;
                            $total = $installment->getTotalPayment();
                            $totalPrinciple = 0.0;
                            $totalRate = 0.0;
                            $totalPayment = 0;
                            ?>
                            @for($i = 1; $i <= $installment->getDuration(); $i++)
                                <tr>
                                    <?php
                                    $monthlyRate = $i == $installment->getDuration() ? ($installment->emiPayment() - $remainAmount) : round($remainAmount * $installment->getEMIRate(), 2);
                                    $amount = $i == 1 ? $installment->firstMonth() + $addRate :$installment->emiPayment();
                                    $totalPayment += $amount;
                                    $debt = $total - $totalPayment;
                                    $principle = $amount - $monthlyRate;
//                                    if ($i == 1) {
//                                        if ($principle > $installment->emiPayment()) {
//                                            $h = $principle - $installment->emiPayment();
//                                            $monthlyRate += $h;
//                                            $principle = $amount - $monthlyRate;
//                                        } else {
//                                            $p = $principle + 10;
//                                            if ($p > $installment->emiPayment()) {
//                                                $monthlyRate += 0.5;
//                                                $principle = $amount - $monthlyRate;
//                                            }
//                                        }
//                                    }
                                    if ($i== $installment->getDuration()) {
                                        $principle = $remainAmount;
                                        $remainAmount = 0;
                                    } else {
                                        $remainAmount -= $principle;
                                    }
                                    // $remainAmount -= $principle;
                                    $totalPrinciple += $principle;
                                    $totalRate += $monthlyRate;
                                    $debt = $i == $installment->getDuration() ? 0 : $debt + $addRate;
                                    ?>
                                    <td>{{$i}} </td>
                                    <td>{{ add_loan_months("2017-01-31", $i)}}</td>
                                    <td>{{ sprintf("%01.2f",$amount) }}</td>
                                    <td>{{ sprintf("%01.2f",$monthlyRate) }}</td>
                                    <td>{{ sprintf("%01.2f",$principle) }} </td>
                                    <td>{{ sprintf("%01.2f",$remainAmount) }}</td>
                                    <td>{{ sprintf("%01.2f",$debt) }}</td>
                                </tr>
                            @endfor
                            <tr>
                                <td>Total Amount</td>
                                <td></td>
                                <td>{{ $totalPayment }}</td>
                                <td>{{ sprintf("%01.2f", $totalRate) }}</td>
                                <td>{{ $totalPrinciple }}</td>
                                <td>0.00</td>
                                <td>0.00</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</section>
@endsection
