@extends('layouts.production')
@section('addCss')
<style media="screen">
    #example2_filter input[type=search] {
        width: 200px;
    }
    table td { vertical-align: middle !important; }
</style>
@endsection
@section('content')
<section class="content-header">
    <h1>
        {{Trans("installments.menu")}}
    </h1>
    <ol class="breadcrumb">
        <li><a href="/"><i class="fa fa-dashboard"></i> Home</a></li>
        <li><a href="{{ Route('installments.index') }}"><i class="fa fa-usd"></i> {{ Trans('debts.menu')}}</a></li>
        <li class="active">{{Trans("dashboard.crud.add")}}</li>
    </ol>
</section>

<!-- Main content -->

<section class="content">
    @include('layouts.includes.message')
    <div class="row">
        <div class="col-md-12">
            <div class="box">
                <div class="box-header with-border">
                    <h3 class="box-title">
                        {{ trans('installments.detail') }}
                    </h3>
                </div>
                <div class="box-body">
                    <table class="table table-striped table-bordered">
                        <thead>
                            <tr>
                                <th>Date</th>
                                <th>EMI</th>
                                <th>Rate</th>
                                <th style="width: 10%;">ID</th>
                                <th>Priciple</th>
                                <th>Remain Priciple</th>
                                <th>Out Stading Debt</th>
                            </tr>
                        </thead>
                        <tbody>
                        <?php 
                            $firstRate = $installment->getTotalRate(); 
                            $totalPayment = 0;
                            $totalPrice = $installment->getTotalPrice();
                            $totalP = 0;
                            $totalRemain = 0;
                            $totalPay = 0;
                            $totalPiciple = 0;
                            $totalRate = 0;
                        ?>
                    @for ($i=1; $i <= $installment->duration ; $i++)
                      <tr>
                          <td>{{ $i }}</td>
                          <td>{{ add_loan_months("2017-01-31", $i) }}</td>
                          <?php 
                          // Find principle vale
                            $monthlyPayment = floor($installment->getEMImonthlyPayment());
                            $sumTotal = $monthlyPayment * $installment->duration;
                            $extraFirstMonth = ($installment->getEMImonthlyPayment()* $installment->duration) - $sumTotal;
                            $mPayment = sprintf("%01.2f",$installment->getEMImonthlyPayment());
                            $totalPay += $mPayment;
                            $rate1 = sprintf("%01.2f",$installment->getEMIRate() * $totalPrice);
                            $p1 = sprintf("%01.2f", $mPayment - $rate1);
                            $totalPrice = sprintf("%01.2f", $totalPrice - $p1);
                            $totalPiciple += $p1;
                            $totalRate += $rate1;
                            $totalDebt = $installment->getTotalEMIPayment();
                          ?>
                          <td>{{ money($mPayment) }}</td>
                          <td>{{ $rate1 }}</td>
                          <td>{{ $p1 }}</td>
    
                            <td>
                                {{ $i == $installment->duration ? 0 : $totalPrice }}
                            </td>
                            <td>{{ money($totalDebt - $totalPay) }}</td>
                      </tr>
                    @endfor
                    <tr>
                        <td colspan="2">
                            Total
                        </td>
                        <td>{{ money($totalPay) }}</td>
                        <td>{{ money($totalRate) }}</td>
                        <td>{{ money($totalPiciple) }}</td>
                    </tr>
              </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
</section>
@endsection
