@extends('layouts.production')
@section('addCss')
{{ HTML::style('assets/vendor/jquery-ui/jquery-ui.min.css') }}
<style media="screen">
    #example2_filter input[type=search] {
        width: 200px;
    }
    legend { padding-bottom: 5px !important; text-align: center; }
    #table-payments td {
        vertical-align: middle;
    }
    table.table-info td { padding: 30px !important;}
    table.table-info td, table.table-info th { text-align: center;}
    .table-info .label { font-size: 16px !important; padding: 20px;  }
</style>
@endsection
@section('content')
<section class="content-header">
    <h1>
        {{Trans("installments.menu")}} (EMI)
    </h1>
    <ol class="breadcrumb">
        <li><a href="/"><i class="fa fa-dashboard"></i> Home</a></li>
        <li><a href="{{ Route('installments.index') }}"><i class="fa fa-credit-card"></i> {{ Trans('installments.menu')}}</a></li>
        <li class="active">{{Trans("dashboard.others.detail")}}</li>
    </ol>
</section>

<!-- Main content -->
<section class="content">
    @include('layouts.includes.message')
    @include('installments.inc.montly_payment')
    <div class="row">
        <div class="col-md-12">
            <!-- Custom Tabs (Pulled to the right) -->
            <div class="nav-tabs-custom">
                <ul class="nav nav-tabs pull-right">
                    <li class="active"><a href="#tab_1-1" data-toggle="tab"><i class="fa fa-th-list"></i> {{ trans("installments.loan_detail") }}</a></li>
                    <li class="pull-left header">
                        <i class="fa fa-user"></i> {{ $installment->full_name_kh }} 
                        @if (!empty($installment->full_name_en)) 
                            ({{ $installment->full_name_en }}) 
                        @endif
                    </li>
                </ul>
                <div class="tab-content">
                    <div class="tab-pane active" id="tab_1-1">
                        <div class="pull-right">
                            <a href="{{ route('loan_customers.show', $installment->customer_id)}}" class="btn btn-sm btn-info"><i class="fa fa-th-list"></i> {{ trans('installments.show_customer') }}</a>
                            <a href="{{ route('emiloans.print', [$installment->id, "type=emi"]) }}" target="_blank" class="btn btn-sm btn-default"><i class="fa fa-print"></i> {{ trans('dashboard.others.print') }}</a>
                        </div>
                        <br />
                        <br />
                        @include('installments.inc.emi_detail')
                        @include("installments.inc.emi_paids")
                        <h3>
                            <i class="fa fa-calendar-o"></i> {{ trans("installments.table_payment") }}
                        </h3>
                        
                        <hr>
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped" id="table-payments">
                            <thead>
                                <th>{{ trans("installments.id")}}</th>
                                <th colspan="2">{{ trans("installments.payment_date") }}</th>
                                <th>{{ trans("installments.emi") }}</th>
                                <th>{{ trans("installments.interest") }}</th>
                                <th>{{ trans("installments.emi_principal") }}</th>
                                <th>{{ trans("installments.balance") }}</th>
                                <th>{{ trans("installments.debt") }}</th>
                                <th>{{ trans("installments.late")}}</th>
                                <th style="width: 15%;">{{ trans("dashboard.crud.actions") }}</th>
                            </thead>
                            <tbody>
                                <?php 
                                $totalPayment = $installment->getTotalPayment();
                                $total_p = 0;
                                $paid_term = 0;
                                $hTerm = $installment->getDuration() / 2;
                                $totalPaidPrincipal = 0;
                                $total_interest = 0;
                                ?>
                                @foreach($payments as $payment)
                                    <?php 
                                        $paid_term += $payment->is_paid ? 1 : 0;
                                        $totalPaidPrincipal += $payment->is_paid ? $payment->principal : 0;
                                        
                                    ?>
                                    <tr class="{{ $payment->is_paid ? "info" : "" }}">
                                        <td>{{ $payment->term_id }}</td>
                                        <td>{{ get_day_week($payment->payment_date) }}</td>
                                        <td>{{ $payment->displayDate() }}</td>
                                        <td>{{ money($payment->amount) }}</td>
                                        <td>{{ money($payment->interest) }}</td>
                                        <td>{{ money($payment->principal) }}</td>
                                        <td>{{ money($payment->balance) }}</td>
                                        <td>{{ $payment->term_id == $installment->getDuration() ? 0 : money( $totalPayment-= $payment->amount) }}</td>
                                        <td>{{ money(lateDay($payment, $installment->status)) }}</td>
                                        <td>@if (user_can('receive_payment'))
                                        @if ($payment->is_paid != true && ($installment->status == "pendding" || $installment->status == 'proccessing') && $payment->enableBtnPyament($payment->id))
                                            <a href="{{ route('installments.formPayment', $payment->id) }}" class="btn btn-sm btn-primary btn-show-payment-modal"><i class="fa fa-usd"></i> {{ trans('installments.payment') }}</a>
                                        @else 
                                            @if ($payment->is_paid || $installment->status == "completed")
                                              <i class="fa fa-check-circle fa-2x text-success"></i>
                                              @if ($payment->is_paid)
                                              <a href="{{ route('installments.paymentHistory', $payment->id) }}" class="btn-payment-history"><i class="fa fa-history fa-2x"></i></a>
                                              @endif
                                            @else 
                                              <i class="fa fa-times-circle fa-2x text-danger"></i>
                                            @endif
                                        @endif
                                        @endif
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                        </div>
                    </div>
            </div>
            <!-- nav-tabs-custom -->
        </div>
    </div>
</section>
@endsection
@section('addJs')
{{ HTML::script('assets/vendor/jquery-ui/jquery-ui.js') }}
{{ HTML::script("js/installment_payment.js") }}
@endsection