@extends('layouts.production')
@section('addCss')
{{ HTML::style('assets/vendor/jquery-ui/jquery-ui.min.css') }}
<style media="screen">
    #example2_filter input[type=search] {
        width: 200px;
    }
    legend { padding-bottom: 5px !important; text-align: center; }
    table.table-info td { padding: 30px !important;}
    table.table-info td, table.table-info th { text-align: center;}
    .table-info .label { font-size: 16px !important; padding: 20px;  }
    .table-payment td {
        vertical-align: middle !important; }
    .inner h3 { font-size: 24px; }
</style>
@endsection
@section('content')
    <section class="content-header">
        <h1>
          {{Trans("installments.menu")}}
            <small>{{Trans("dashboard.others.detail")}}</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="/"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="{{ Route('installments.index') }}"><i class="fa fa-credit-card"></i> {{ Trans('installments.menu')}}</a></li>
            <li class="active">{{Trans("dashboard.others.detail")}}</li>
        </ol>
    </section>

<!-- Main content -->
<section class="content">
    @include('layouts.includes.message')
    @include('installments.inc.montly_payment')
    <div class="row">
        <div class="col-md-12">
            <div class="box">
                <div class="box-header with-border">
                    <h3 class="box-title" style="padding-top: 5px;"><i class="fa fa-th-list"></i> {{ trans('installments.detail') }}</h3>
                    <div class="pull-right">
                        <a href="{{ route('loan_customers.show', $installment->customer_id)}}" class="btn btn-sm btn-info"><i class="fa fa-th-list"></i> {{ trans('installments.show_customer') }}</a>
                        <a href="{{ route('installments.print', $installment->id) }}" target="_blank" class="btn btn-sm btn-default"><i class="fa fa-print"></i> {{ trans('dashboard.others.print') }}</a>
                        <a href="{{ route('installments.print', [$installment->id, "type=detail"]) }}" target="_blank" class="btn btn-sm btn-default"><i class="fa fa-print"></i> {{ trans('installments.print') }}</a>
                    </div>
                </div>
                <div class="box-body">
                    @include("installments.inc.loan_detail")
                    <?php
                        $totalI = 0;
                        $totalP = 0;
                        $term = 0;
                        $paidTerm = 0;
                        $principal = 0;
                        foreach ($payments as $payment) {
                            $term += $payment->is_paid ? 1 : 0;
                            $paidTerm += $payment->is_paid && !$payment->is_paid_all ? 1 : 0;
                            $totalI += $payment->is_paid && !$payment->is_paid_all ? $payment->amount - $installment->getMonthlyPriciple() : 0;
                            $totalP += $payment->is_paid && !$payment->is_paid_all ? $installment->getMonthlyPriciple() : 0;
                            $principal += $installment->getMonthlyPriciple();
                        }
                        $totalPayment = ($installment->status == "completed" && $term != $installment->getDuration()) ? $installment->paid_off_amount : 0;
                        $totalPrincipal    = ($installment->status == "completed" && $term != $installment->getDuration()) ? $installment->getRemainPrinciple($paidTerm) : 0;
                        $totalRate    = ($installment->status == "completed" && $term != $installment->getDuration()) ? $installment->getRate3Moths($paidTerm) : 0;
                        $totalInterest = $totalI + $totalRate;
                        $total_principal = $totalP + $totalPrincipal;
                        $total_payment = $totalInterest + $total_principal;
                        $remainP = $installment->status == "completed" ? 0 : $principal - $total_principal;
                        ?>
                    @include("installments.inc.box_graph")
                    <div class="box box-solid box-default">
                        <div class="box-header">
                            <h3 class="box-title"><i class="fa fa-credit-card-alt"></i></h3>
                        </div>
                        <div class="box-body">
                            <div class="row">
                                <div class="col-md-2">
                                    <!-- small box -->
                                    <div class="small-box bg-gray">
                                        <div class="inner">
                                            <h3>{{ $term }}</h3>
                                            <p>{{ trans("payments.total_term") }}</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <!-- small box -->
                                    <div class="small-box bg-green">
                                        <div class="inner">
                                        <h3>{{ money($totalInterest) }}</h3>

                                        <p>{{ trans("payments.total_interest") }}</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <!-- small box -->
                                    <div class="small-box bg-yellow">
                                        <div class="inner">
                                        <h3>{{ money($total_principal) }}</h3>

                                        <p>{{ trans("payments.total_principal") }}</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <!-- small box -->
                                    <div class="small-box bg-aqua">
                                        <div class="inner">
                                        <h3>{{ money($total_payment) }}</h3>

                                        <p>{{ trans("payments.total_received") }}</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <!-- small box -->
                                    <div class="small-box bg-red">
                                        <div class="inner">
                                            <?php
                                            $totalDebt = $installment->status == "completed" ? 0 : $installment->getFutureValue() - $total_payment;
                                            ?>
                                        <h3>{{ money($totalDebt) }}</h3>

                                        <p>{{ trans("payments.total_debt") }}</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                <div class="box box-solid box-success">
                    <div class="box-header">
                        <h3 class="box-title"><i class="fa fa-calendar-o"></i> {{ trans("installments.table_payment") }}</h3>
                    </div>
                    <div class="box-body">
                        <div class="table-responsive">
                            @include("installments.inc.table_loan")
                        </div>
                    </div>
                </div>
            </div>
        </div>
        </div>
  </div>
</section>
@endsection
@section('addJs')
    {{ HTML::script('plugins/datepicker/bootstrap-datepicker.js') }}
    {{ HTML::script('plugins/datepicker/locales/bootstrap-datepicker.kh.js') }}
    {{ HTML::script("http://www.chartjs.org/dist/2.7.0/Chart.bundle.js") }}
    {{ HTML::script("http://www.chartjs.org/samples/latest/utils.js")}}
    {{ HTML::script("js/min/loan_v2.js")}}
    <script>
        var randomScalingFactor = function() {
            return Math.round(Math.random() * 100);
        };
        var config = {
            type: 'pie',
            data: {
                datasets: [{
                    data: [
                        <?= $installment->getPriciple() ?>,  <?= $installment->getTotalInterest() ?>
                    ],
                    backgroundColor: [
                        window.chartColors.yellow,
                        window.chartColors.green,
                    ],
                    label: 'Dataset 1'
                }],
                labels: [
                    "{{ trans('reports.total_price_in') }}",
                    "{{ trans('reports.total_rate') }}",
                ]
            },
            options: {
                responsive: true
            }
        };
        var color = Chart.helpers.color;
        var barChart = {
            labels: ["{{ trans('payments.total_debt') }}"],
            datasets: [{
                label: "{{ trans('payments.total') }}",
                backgroundColor: color(window.chartColors.red).alpha(0.5).rgbString(),
                borderColor: window.chartColors.red,
                borderWidth: 1,
                data: [
                    <?= $totalDebt; ?>
                ]
            },
                {
                    label: "{{ trans('payments.total_principal') }}",
                    backgroundColor: color(window.chartColors.yellow).alpha(0.5).rgbString(),
                    borderColor: window.chartColors.yellow,
                    borderWidth: 1,
                    data: [
                        <?= $remainP; ?>
                    ]
                }
                ,{
                    label: "{{ trans('payments.total_interest') }}",
                    backgroundColor: color(window.chartColors.green).alpha(0.5).rgbString(),
                    borderColor: window.chartColors.green,
                    borderWidth: 1,
                    data: [
                        <?= $totalDebt - $remainP ?>
                    ]
                }]
        };
        window.onload = function() {
            var ctx = document.getElementById("chart-area").getContext("2d");
            window.myPie = new Chart(ctx, config);
            var bar = document.getElementById("canvas-bar").getContext("2d");
            window.myBar = new Chart(bar, {
                type: 'bar',
                data: barChart,
                options: {
                    responsive: true,
                    legend: {
                        position: 'top',
                    },
                    title: {
                        display: false,
                        text: 'Chart.js Bar Chart'
                    }
                }
            });
        };
    </script>

    <script>
        $(function () {
            $('.btn-show-modal').on('click', function (e) {
                e.preventDefault();
                var url = $(this).attr('href');
                $.ajax({
                    url: url,
                    dataType: "html",
                    success: function (data) {
                        $("#form-payment-body").html(data);
                        $('#payment_date').datepicker({
                            format: "dd/mm/yyyy",
                            todayHighlight: true,
                            autoclose: true
                        });
                        $('#monthly-payment-modal').modal({backdrop: 'static', keyboard: false}).show();
                        $("#monthly-payment-modal").on('shown.bs.modal', function () {
                            $("#receipt_id").focus();
                        });
                    }
                });
            });
            $(".btn-delete-payment").on("click", function (e) {
                e.preventDefault();
                var me = $(this);
                var url = me.attr('href');
                swal({
                        title: me.data('msg'),
                        type: "warning",
                        showCancelButton: true,
                        confirmButtonText: me.data('yes'),
                        cancelButtonText: me.data('no'),
                        closeOnConfirm: false
                    },
                    function(){
                        $.ajax({
                            url: url,
                            type: "DELETE",
                            success: function (data) {
                                if (data.error) {
                                    swal("", data.message, "error")
                                    console.log(data);
                                } else {
                                    console.log(data);
                                    swal("", data.message, "success");
                                    window.location.reload();
                                }
                            }
                        });
                    });
            });
        });
    </script>

@endsection
