@extends('layouts.production')
@section('addCss')
<style media="screen">
    #example2_filter input[type=search] {
        width: 200px;
    }
    table td { vertical-align: middle !important; }
</style>
@endsection
@section('content')
    <section class="content-header">
        <h1>
            {{Trans("installments.menu")}}
        </h1>
        <ol class="breadcrumb">
            <li><a href="/"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="{{ Route('installments.index') }}"><i class="fa fa-usd"></i> {{ Trans('debts.menu')}}</a></li>
            <li class="active">{{Trans("dashboard.crud.add")}}</li>
        </ol>
    </section>

    <!-- Main content -->

    <section class="content">
        @include('layouts.includes.message')
        <div class="row">
            <div class="col-md-12">
                <div class="box">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-th-list"></i> Old Installment Loan</h3>
                    </div>
                    <div class="box-body">
                        <table class="table table-striped table-bordered">
                            <thead>
                                <tr>
                                    <th style="width: 10%;">ID</th>
                                    <th>Date</th>
                                    <th>Monthly Paymen</th>
                                    <th>Interest</th>
                                    <th>Principal</th>
                                </tr>
                            </thead>
                            <tbody>
                                @for ($i=1; $i <= $installment->duration ; $i++)
                                    <tr>
                                        <td>{{ $i }}</td>
                                        <td>{{ format_date_installment($installment->created_at, $i) }}</td>
                                        <?php
                                            $payment = $i == 1 ? $installment->getPayFirstMonth() : $installment->getMonthlyPayment();
                                            $p = $installment->getMonthlyPriciple();
                                            $i = $payment - $p;
                                        ?>
                                        <td>{{ money($payment) }}</td>
                                        <td>{{ money($payment - $p) }}</td>
                                        <td>{{ money($p) }}</td>
                                    </tr>
                                @endfor
                            </tbody>
                            </table>
                    </div>
                </div>
            </div>
        </div>
      </div>
    </div>
  </div>
</section>
@endsection