@extends('layouts.production')
@section('addCss')
    <style media="screen">
        #example2_filter input[type=search] {
            width: 200px;
        }
        table td { vertical-align: middle !important; }
        td > .label { padding: 5px !important; font-weight: normal !important; }
    </style>
@endsection
@section('content')
    <section class="content-header">
        <h1>
            {{Trans("installments.menu")}}
            <small>{{ trans("dashboard.others.show_all") }}</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="/"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="{{ Route('installments.index') }}"><i class="fa fa-calendar-o"></i> {{ Trans('installments.menu')}}</a></li>
            <li class="active">{{Trans("dashboard.others.show_all")}}</li>
        </ol>
    </section>
    <!-- Main content -->

    <section class="content">
        @include('layouts.includes.message')
        <div class="row">
            <div class="col-md-12">
                <div class="box box-info">
                    <div class="box-header with-border">
                        @include("installments.inc.search_form")
                    </div>
                    <div class="box-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>{{ trans('installments.code') }}</th>
                                    <th>{{ trans('installments.customer_id') }}</th>
                                    <th>{{ trans('installments.date') }}</th>
                                    <th>{{ trans('installments.duration')}}</th>
                                    <th>{{ trans('installments.total_price') }}</th>
                                    <th>{{ trans('dashboard.others.status') }}</th>
                                    <th>{{ trans('dashboard.crud.actions') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                            @if (count($installments) > 0)
                                @foreach ($installments as $installment)
                                <tr>
                                    <td>{{ convertInvoiceNumber($installment->id) }} @if ($installment->loan_type == "emi") <span class="label label-primary">(EMI)</span> @endif</td>
                                    <td><a href="{{ route('loan_customers.show', $installment->customer_id) }}">{{ $installment->full_name_kh }} - {{ $installment->tel }}</a></td>
                                    <td>{{ get_day_week($installment->in_date) }} {{ d_format($installment->in_date) }}</td>
                                    <td>{{ $installment->duration }}</td>
                                    <td>{{ money($installment->total_price) }}</td>
                                    <td>
                                    <?php
                                        $status = "label-warning";
                                        if ($installment->status == "proccessing") {
                                            $status = "label-info";
                                        } elseif ($installment->status == "completed") {
                                            $status = 'label-success';
                                        }
                                    ?>
                                    <span class="label {{ $status }}">
                                        {{ trans('installments.status.'.$installment->status) }}</td>
                                    </span>
                                    <td>
                                        <a href="{{ route('installments.show', $installment->id) }}" class="btn btn-sm btn-default"><i class="fa fa-th-list"></i> {{ trans('dashboard.others.show') }}</a>
                                    </td>
                                </tr>
                            @endforeach
                        @else
                            <tr>
                                <td colspan="7" class="text-center">No record.........</td>
                            </tr>
                        @endif
                        </tbody>
                    </table>
                </div>
                        @if (empty(Input::get("paginate")) || Input::get("paginate") != "all")
                            <div class="row">
                                <div class="col-md-4">
                                    <p style="margin-top: 10px;">Total Records : {{ $installments->getTotal() }} Page {{ $installments->getCurrentPage() }} of {{ $installments->getLastPage() }}</p>
                                </div>
                                <div class="col-md-8 text-right">
                                    {{ $installments->appends(Request::except('page'))->links() }}
                                </div>
                            </div>
                        @else
                            @if ($installments->count() > 0)
                                Total Records : {{ $installments->count() }}
                            @endif
                        @endif
            </div>
        </div>
    </div>
  </div>
</section>
@endsection
@section('addJs')
  {{ HTML::script('plugins/datepicker/bootstrap-datepicker.js') }}
  {{ HTML::script('plugins/datepicker/locales/bootstrap-datepicker.kh.js') }}
@endsection
