<table class="table table-bordered table-payment">
    <thead>
    <tr>
        <th style="width: 5%;">{{ trans('installments.id') }}</th>
        <th colspan="2">{{ trans('installments.date_payment')}}</th>
        <th>{{ trans('installments.monthly_payment') }}</th>
        <th>{{ trans("installments.principal") }}</th>
        <th>{{ trans("installments.interest") }}</th>
        <th>{{ trans('installments.late') }}</th>
        <th style="width: 15%;">{{ trans('dashboard.crud.actions') }}</th>
    </tr>
    </thead>
    <tbody>
    <?php $i = 1; ?>
    @if (count($payments) > 0)
        @foreach ($payments as $pay)
            <tr class="{{ $pay->is_paid ? "active" : "" }}">
                <td>{{ $i }}</td>
                <td style="width: 5%;">{{ get_day_week($pay->payment_date) }} </td>
                <td>{{ $pay->displayDate() }}</td>
                <td>{{ money($pay->amount) }}</td>
                <td>{{ money($installment->getMonthlyPriciple()) }}</td>
                <td>{{ money($pay->amount - $installment->getMonthlyPriciple()) }}</td>
                <td>{{ money(lateDay($pay, $installment->status)) }}</td>
                <td>
                    @if (user_can('receive_payment'))
                        @if ($pay->is_paid != true
                            && ($installment->status == "pendding" || $installment->status == 'proccessing')
                            && $pay->enableBtnPyament($pay->id)
                            &&  $pay->enableBtnPyament($pay->id)
                            && ($term + 1) == $pay->term_id)
                            <a href="{{ route('installments.formPayment', $pay->id) }}"
                               class="btn btn-sm btn-primary btn-show-payment-modal"><i
                                        class="fa fa-usd"></i> {{ trans('installments.payment') }}</a>
                            @if ($pay->term_id != $installment->duration)
                                <a href="{{ route('installments.formPaymentAll', $pay->id) }}"
                                   class="btn btn-sm btn-warning btn-show-payment-modal"><i
                                            class="fa fa-credit-card"></i> {{ trans('installments.paid') }}</a>
                            @endif
                        @else
                            @if ($pay->is_paid || $installment->status == "completed")
                                @if ($pay->is_paid)
                                    <a href="{{ route('installments.paymentHistory', $pay->id) }}"
                                       class="btn btn-sm btn-primary btn-payment-history"><i class="fa fa-history"></i></a>
                                    <?php
                                    $start = \Carbon\Carbon::today();
                                    $start->startOfMonth();
                                    $end = \Carbon\Carbon::today();
                                    $end->endOfMonth();
                                    ?>
                                    @if ($pay->payment_date > $start || get_config('show_edit_and_delete_old_payment') == 'yes')
                                        @if ($pay->is_paid_all == false)
                                            <a href="{{ route('payments.edit', $pay->id) }}"
                                               class="btn btn-sm btn-success btn-show-modal"><i class="fa fa-edit"></i></a>
                                        @endif
                                        {{--  @if (user_can('delete_payment'))  --}}
                                        <a href="{{ route('payments.destroy', $pay->id) }}"
                                           class="btn btn-sm btn-danger btn-delete-payment"
                                           data-msg="Do you want to delete payment?"><i class="fa fa-trash"></i></a>
                                        {{--  @endif          --}}
                                    @endif
                                @else
                                    <i class="fa fa-check-circle fa-2x text-success"></i>
                                @endif
                            @else
                                <i class="fa fa-times-circle fa-2x text-danger"></i>
                            @endif
                        @endif
                    @endif
                </td>
            </tr>
            <?php $i++; ?>
        @endforeach
    @endif
    </tbody>
</table>