<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="UTF-8">
	<title>Invoice V1</title>
	{{ HTML::style('css/installment.css') }}
	<style media="print">
		@page {
			size: A4;
			margin-top: 10px !important;
			margin: 10px;
			margin-left: 10px;

		}
		body { font-size: 12px !important; color: #000 !important; }
		img { width: 150px !important; }
		hr { border-color: #333333!important; margin-top: 0; margin-bottom: 0;}
		/*.table-nobordered { border: 1px solid #333333 !important; }*/
		.table-nobordered th, .table-nobordered td { border: 0 !important;  padding: 5px; color: #000 !important;}
		.table-nobordered { margin-bottom: 5px; }
		table, th, td { border-color: #333333 !important; padding: 5px !important; color: #000 !important;}
		th { border-bottom-width: 1px !important;}
		h2 { font-family: "Khmer OS Muol";}
		h2, h3, p { text-align: center; }
		h2 { font-size: 22px !important; margin-bottom: 5px !important; }
		h3 { font-size: 18px !important; margin-top: 0 !important; }
		p { margin: 5px !important; color: #000 !important;}
		table.table-paid{
			border: 1px solid #333;
		}
		table th { font-weight: bold !important; }
		.table-paid th, .table-paid td{
			border: 1px solid #333;
		}
		.table-paid tr td:last-child{
			border-right: none;
		}
		.strike-trough{
			position: relative;
		}
		.strike-trough:after{
			content: '';
			display: block;
			border-bottom: 1px solid #333;
			right: 0;
			position: absolute;
			left: 0;
			padding-top: 20px;
			margin-left: 15px;
			margin-right: 15px;
		}
		.logo { padding-top: 30px; padding-bottom: 40px; }

	</style>
	<style>
		hr { border-color: #333333!important; margin-top: 0; margin-bottom: 0;}
		/*.table-nobordered { border: 1px solid #333333 !important; }*/
		.table-nobordered th, .table-nobordered td { border: 0 !important; }
		table, th, td { border-color: #333333 !important;}
		th { border-bottom-width: 1px !important;}
		h2 { font-family: "Khmer OS Muol";}
		h2, h3, p { text-align: center; }
		table.table-paid{
			border: 1px solid #333;
		}
		.table-paid th, .table-paid td{
			border: 1px solid #333;
		}
		.table-paid tr td:last-child{
			border-right: none;
		}
		.strike-trough{
			position: relative;
		}
		.strike-trough:after{
			content: '';
			display: block;
			border-bottom: 1px solid #333;
			right: 0;
			position: absolute;
			left: 0;
			padding-top: 20px;
			margin-left: 15px;
			margin-right: 15px;
		}
		.logo { padding-top: 30px; padding-bottom: 40px; }
	</style>
	 <link href="https://fonts.googleapis.com/css?family=Chenla|Roboto:500" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css?family=Chenla|Metal" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css?family=Roboto" rel="stylesheet">
    <style media="screen">
        .required {
            color: red !important;
        }
        .text-danger { color: #dd4b39 !important; }
        body,.h1, .h2, .h3, .h4, .h5, .h6, h1, h2, h3, h4, h5, h6{
            font-family: 'Chenla', 'Roboto';
            <!-- font-family: 'Metal', cursive; -->
        }
    </style>
</head>
<script>
	window.print();
</script>
<body>
	<div class="container-fluid">
		<div class="row">
			<div class="col-xs-3" >
				{{ HTML::image(get_config('company_logo'), "logo", ['width' => '200px;', 'class' => 'logo'])}}
                <h3 class="text-left">{{ trans('installments.menu') }}</h3>
			</div>
			<div class="col-xs-6">
				<h2>{{ get_config('company_name') }}</h2>
				<h3>{{ get_config('company_name_en') }}</h3>
        <p>{{ get_config('company_detail') }}</p>

			</div>
		</div>

		<div class="row">
			<div class="col-xs-12">
                <hr>
				<table class="table table-nobordered">
					<tr>
						<th style="width: 15%;">{{ trans('installments.code') }}</th>
						<td>{{ convertInvoiceNumber($installment->id) }}</td>
						<th style="width: 15%;">{{ trans('installments.user') }}</th>
						<td style="width: 15%;">{{ $installment->first_name }} {{ $installment->last_name }}</td>
					</tr>
					<tr>
						<th>{{ trans('installments.date') }}</th>
						<td>{{ get_day_week($installment->created_at)}} {{ format_date_installment($installment->created_at) }}</td>
					</tr>
				</table>
				<table class="table table-nobordered">
					<tr>
						<th>{{ trans('installments.customer_name') }}</th>
						<td>{{ $installment->full_name_kh }}</td>
						<th>{{ trans('installments.product_name') }}</th>
						<td>{{ $installment->product_name }}</td>
						<th>{{ trans('installments.duration') }}</th>
						<td>{{ $installment->duration }}</td>
					</tr>
					<tr>
						<th>{{ trans('customers.sex') }}</th>
						<td>{{ trans('customers.gender.'.$installment->gender)}}</td>
						<th>{{ trans('installments.total_price') }}</th>
						<td>{{ money($installment->total_price) }}</td>
						<th>{{ trans('installments.principal')}}</th>
						<td>{{ money($installment->getMonthlyPriciple())}}</td>
					</tr>
					<tr>
						<th>{{ trans('customers.tel') }}</th>
						<td>{{ $installment->tel }}</td>
						<th>{{ trans('installments.deposit') }}</th>
						<td>{{ money($installment->deposit) }}</td>
						<th>{{ trans('installments.total_pay')}}</th>
						<td>{{ money($installment->getFutureValue() )}}</td>
					</tr>
					<tr>
						<th></th>
						<td></td>
						{{-- <th>{{ trans('installments.rate') }}</th>
						<td>{{ $installment->rate }}%</td> --}}
						<th>{{ trans('installments.pay_of_day') }}</th>
						<td>{{ get_day_week($payOffDay->payment_date)}} {{ $payOffDay->displayDate() }}</td>
					</tr>
          @if ($installment->status == "completed")
          <tr>
              <th></th>
              <td></td>
              <th>{{ trans('installments.total_paid_all') }}</th>
              <td>{{ money($installment->paid_off_amount) }}</td>
              <th>{{ trans('installments.date_paid_all') }}</th>
              <td>{{get_day_week($installment->paid_off_date) }} {{  format_date_installment($installment->paid_off_date) }}</td>
          </tr>
          @endif
				</table>
		<table class="table table-paid">
					<thead>
              <tr>
                  <th style="width: 5%;">{{ trans('installments.id') }}</th>
                  <th colspan="2" style="width: 20%;">{{ trans('installments.date_payment')}}</th>
                  <th style="width: 15%;">{{ trans('installments.monthly_payment') }}</th>
                  <th style="width: 15%;">{{ trans('installments.payment_name') }}</th>
                  <th style="width: 15%;">{{ trans('installments.reciever_name') }}</th>
                  <th style="width: 15%;">{{ trans('installments.payment_date') }}</th>
              </tr>
           </thead>
           <tbody>
           	@if (count($payments) > 0)
           		<?php $i = 1; ?>
           		@foreach ($payments as $pay)
              <?php 
                $payment = $pay->getPiadDetail($pay->id);
              ?>
           		<tr>
           			<td>{{ $i }}</td>
           			<td style="width: 10%;">{{ get_day_week($pay->payment_date) }}</td>
                    <td>{{ format_date_installment($pay->payment_date) }}</td>
           			<td>{{ money($pay->amount) }}</td>
                <td>{{ !empty($payment) ? $payment->payment_name : "" }}</td>
                <td>{{ !empty($payment) ? $payment->first_name . " " . $payment->last_name : "" }}</td>
           			<td>{{ !empty($payment) ? $payment->paymentDate() : "" }}</td>
           		</tr>
           		<?php $i++; ?>
           		@endforeach
           	@endif
           </tbody>
				</table>
			</div>
		</div>
	</div>
</body>
</html>
