<div class="modal fade" tabindex="-1" role="dialog" id="new-customer-modal">
<div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title text-center"><i class="fa fa-user-plus"></i> {{ trans('customers.menu') }}</h4>
      </div>
      <div class="modal-body">
        {{ Form::open(['id' => 'form-new-customer', 'route' => 'installments.newCustomer']) }}
         <div class="row">
          <div class="col-md-6 form-group">
            {{ Form::label('first_name', Trans('customers.first_name')) }}
            {{ Form::text('first_name', null, [
              'class' => 'form-control',
              'placeholder' => Trans('customers.first_name'),
              'required' => "required"
            ]) }}
          </div>
          <div class="col-md-6 form-group">
            {{ Form::label('last_name', Trans('customers.last_name')) }}
            {{ Form::text('last_name', null, [
              'class' => 'form-control',
              'placeholder' => Trans('customers.last_name'),
              'required' => "required"
            ]) }}
          </div>
        </div>
        <div class="row">
            <?php
            if(App::getLocale() == "kh") {
              $sex = [
                'm' => 'ប្រុស',
                'f' => 'ស្រី',
              ];
            }
            else {
              $sex = [
                'm' => 'Male',
                'f' => 'Female',
              ];
            }
          ?>
          <div class="col-md-6 form-group">
            <?php
            $selected = isset($customer) ? $customer->sex : "";
             ?>
            {{ Form::label('sex', Trans('customers.sex')) }}
            {{ Form::select('sex', $sex, $selected, ['class' => 'form-control select2']) }}
          </div>
          <div class="col-md-6 form-group">
            {{ Form::label('dob',Trans("users.dob")) }}
            <div class="input-group date" data-provide="datepicker">
              {{ Form::text('dob', null, [
                'class' => "form-control",
                'placeholder' => Trans("users.dob")
              ]) }}
              <div class="input-group-addon">
                  <i class="fa fa-calendar-o"></i>
              </div>
            </div>
          </div>
          <div class="col-md-6 form-group">
            {{ Form::label('age', Trans('customers.age')) }}
            {{ Form::number('age', null, [
              'class' => 'form-control',
              'placeholder' => Trans('customers.age')
            ]) }}
          </div>
          <div class="col-md-6 form-group">
              {{ Form::label('tel', Trans('customers.tel')) }}
              {{ Form::text('tel', null, [
                'class' => 'form-control',
                'placeholder' => Trans('customers.tel'),
                'required' => "required"
              ]) }}
              @if(isset($errors))
                <span class="help-inline text-danger">{{ $errors->first('tel')}}</span>
              @endif
            </div>

        </div>
        <div class="row">

          <div class="col-md-6 form-group">
            {{ Form::label('id_card', Trans('customers.id_card')) }}
            {{ Form::text('id_card', null, [
              'class' => 'form-control',
              'placeholder' => Trans('customers.id_card'),
            ]) }}
          </div>
          <div class="col-md-6 form-group">
            {{ Form::label('address', Trans('customers.address')) }}
            {{ Form::textarea('address', null, [
              'class' => "form-control",
              'placeholder' => Trans('customers.address'),
              'rows' => '2'
            ]) }}
          </div>
          <div class="col-md-6 form-group">
            {{ Form::label('note', Trans('customers.note')) }}
            {{ Form::textarea('note', null, [
              'class' => "form-control",
              'placeholder' => Trans('customers.note'),
              'rows' => '2'
            ]) }}
          </div>
        {{ Form::close() }}
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">{{ trans('dashboard.crud.cancel') }}</button>
        <button type="button" class="btn btn-primary btn-add-customer">{{ trans('dashboard.crud.add') }}</button>
      </div>
    </div><!-- /.modal-content -->
  </div><!-- /.modal-dialog -->
</div><!-- /.modal -->
