<div class="row">
    <div class="col-md-4">
        <table class="table table-bordered table-striped">
            <tr>
                <th>{{ trans('installments.date') }}</th>
                <td>{{ $installment->displayDate() }}</td>
            </tr>
            <tr>
                <th>{{ trans('installments.customer_id') }}</th>
                <td>{{ $installment->full_name_kh }}</td>
            </tr>
            <tr>
                <th>{{ trans('customers.sex')}}</th>
                <td>{{ trans('customers.gender.'.$installment->gender) }}</td>
            </tr>
            <tr>
                <th>{{ trans('customers.tel') }}</th>
                <td>{{ $installment->tel }}</td>
            </tr>
        </table>
    </div>
    <div class="col-md-8">
        <table class="table table-striped table-bordered hidden-xs">
            <tr>
                <th style="width: 25%;">{{ trans('installments.product_name') }}</th>
                <td  style="width: 25%;">{{ $installment->product_name }}</td>
                <th style="width: 25%;">{{ trans('installments.total_price')}}</th>
                <td style="width: 25%;">{{ money($installment->getTotalPrice()) }}</td>
            </tr>
            <tr>
                <th style="width: 25%;">{{ trans('installments.note') }}</th>
                <td  style="width: 25%;">{{ $installment->note }}</td>
            </tr>
            <tr>
                <th style="width: 25%;">{{ trans('installments.model') }}</th>
                <td  style="width: 25%;">{{ $installment->model }}</td>
                <th style="width: 25%;">{{ trans('installments.imie')}}</th>
                <td style="width: 25%;">{{ $installment->imie }}</td>
            </tr>
            <tr>
                <th>{{ trans('installments.deposit') }}</th>
                <td>{{ money($installment->getDeposit()) }}</td>
                <th>{{ trans('installments.duration') }}</th>
                <td>{{ $installment->getDuration() }}</td>
            </tr>
            <tr>
                <th>{{ trans('installments.rate') }}</th>
                <td>{{ $installment->rate }}%</td>
                <th>{{ trans('installments.principal') }}</th>
                <td>{{ money($installment->getMonthlyPriciple()) }}</td>
            </tr>
            <tr>
                <th>{{ trans('installments.total_pay') }}</th>
                <td>{{ money($installment->getFutureValue()) }}</td>
                <th>{{ trans('installments.pay_of_day') }}</th>
                <td>{{ get_day_week($payOffDay->payment_date)}} {{ $payOffDay->displayDate() }}</td>
            </tr>
            @if ($installment->status == "completed")
            <tr>
                <th>{{ trans('installments.total_paid_all') }}</th>
                <td>{{ money($installment->paid_off_amount) }}</td>
                <th>{{ trans('installments.date_paid_all') }}</th>
                <td>{{get_day_week($installment->paid_off_date) }} {{  format_date_installment($installment->paid_off_date) }}</td>
            </tr>
            @endif
        </table>
        <table class="table table-striped table-bordered visible-xs">
            <tr>
                <th style="width: 25%;">{{ trans('installments.product_name') }}</th>
                <td  style="width: 25%;">{{ $installment->product_name }}</td>
            </tr>
            <tr>
                <th style="width: 25%;">{{ trans('installments.total_price')}}</th>
                <td style="width: 25%;">{{ money($installment->getTotalPrice()) }}</td>
            </tr>
            <tr>
                <th style="width: 25%;">{{ trans('installments.model') }}</th>
                <td  style="width: 25%;">{{ $installment->model }}</td>
            </tr>
            <tr>
                <th style="width: 25%;">{{ trans('installments.imie')}}</th>
                <td style="width: 25%;">{{ $installment->imie }}</td>
            </tr>
            <tr>
                <th>{{ trans('installments.deposit') }}</th>
                <td>{{ money($installment->getDeposit()) }}</td>
            </tr>
            <tr>
                <th>{{ trans('installments.duration') }}</th>
                <td>{{ $installment->getDuration() }}</td>
            </tr>
            <tr>
                <th>{{ trans('installments.rate') }}</th>
                <td>{{ $installment->rate }}%</td>
            </tr>
            <tr>
                <th>{{ trans('installments.principal') }}</th>
                <td>{{ money($installment->getMonthlyPriciple()) }}</td>
            </tr>
            <tr>
                <th>{{ trans('installments.total_pay') }}</th>
                <td>{{ money($installment->getFutureValue()) }}</td>
            </tr>
            <tr>
                <th>{{ trans('installments.pay_of_day') }}</th>
                <td>{{ get_day_week($payOffDay->payment_date)}} {{ $payOffDay->displayDate() }}</td>
            </tr>
            @if ($installment->status == "completed")
            <tr>
                <th>{{ trans('installments.total_paid_all') }}</th>
                <td>{{ money($installment->paid_off_amount) }}</td>
            </tr>
            <tr>
                <th>{{ trans('installments.date_paid_all') }}</th>
                <td>{{get_day_week($installment->paid_off_date) }} {{  format_date_installment($installment->paid_off_date) }}</td>
            </tr>
            @endif
        </table>
    </div>
</div>