<table class="table table-striped table-bordered">
    <thead>
        <tr>
            <th>{{ trans('installments.id') }}</th>
            <th>{{ trans('installments.date_payment')}}</th>
            <th>{{ trans('installments.monthly_payment')}}</th>
        </tr>
    </thead>
    <tbody>
    <?php 
        $totalPayment = 0;
        $paymentIds = [];
     ?>
    @foreach ($payments as $pay)
        <?php $totalPayment += $pay->amount; ?>
        <tr>
            <td>{{ $pay->term_id }}</td>
            <td>{{ $pay->displayDate() }}</td>
            <td>{{ money($pay->amount) }}</td>
        </tr>
    @endforeach
    <tr>
        <td colspan="2">Total : </td>
        <td>{{ money($totalPayment) }}</td>
    </tr>
    </tbody>
</table>
{{ Form::open(['method' => 'post', 'route' => "installments.pyamentNP"]) }}
<div class="row">
    <div class="col-md-6 form-group">
         {{ Form::hidden('number', $number) }}
         {{ Form::hidden('payment_amount', $totalPayment) }}
         {{ Form::hidden('installment_id', $installment_id) }}
         {{ Form::label("receipt_id", trans('installments.receipt_id')) }} <span class="required">*</span>
         {{ Form::text('receipt_id', null, [
             'class'    =>  'form-control',
             'id'       =>  'receipt_id',
             'placeholder'  =>  trans('installments.receipt_id')
         ]) }}
     </div>
    <div class="col-md-6 form-group"> 
     {{ Form::label("payment_name", trans('installments.payment_name')) }} <span class="required">*</span>
     {{ Form::text('payment_name', null, [
         'class'    =>  'form-control',
         'placeholder'  =>  trans('installments.payment_name')
     ]) }}
    </div> 
</div>
<div class="row">
    <div class="col-md-6 form-group">
         {{ Form::label("recieve_amount", trans('installments.recieve_amount')) }}
         {{ Form::number('recieve_amount', $totalPayment, [
             'class'    =>  'form-control',
             'placeholder'  =>  trans('installments.recieve_amount'),
         ]) }}
     </div>
     <div class="col-md-6 form-group">
         {{ Form::label("late_amount", trans('installments.late')) }}
         {{ Form::number('late_amount', 0, [
             'class'    =>  'form-control',
             'placeholder'  =>  trans('installments.late'),
         ]) }}
     </div>
     <div class="col-md-6 form-group">
         {{ Form::label("total_as_letter", trans('installments.total_as_letter')) }}
         {{ Form::text('total_as_letter', null, [
             'class'    =>  'form-control',
             'placeholder'  =>  trans('installments.total_as_letter'),
         ]) }}
     </div>
     <div class="col-md-6 form-group">
         {{ Form::label("in_digit_of", trans('installments.in_digit_of')) }}
         {{ Form::text('in_digit_of', null, [
             'class'    =>  'form-control',
             'placeholder'  =>  trans('installments.in_digit_of'),
         ]) }}
     </div>
     <div class="col-md-12 form-group">
         {{ Form::label("with_doc", trans('installments.with_doc')) }}
         {{ Form::text('with_doc', null, [
             'class'    =>  'form-control',
             'placeholder'  =>  trans('installments.with_doc'),
         ]) }}
     </div>
</div>     
{{ Form::close() }}