{{ Form::model($payment, [
    'route' => $type ? ['payments.update', $payment->id] : "installments.payment",
    'method' => $type ? "PUT" : "POST"
 ]) }}
<fieldset>
    <legend>{{ trans('installments.id') }} {{ $payment->term_id }}
        - {{ get_day_week($payment->payment_date)}} {{ $payment->displayDate() }}
        ចំនួនត្រូវបង់ {{ money($payment->totalAndLate()) }}</legend>
</fieldset>
<div class="row">
    <div class="col-md-6 form-group">
        {{ Form::hidden('payment_id', $payment->id) }}
        {{ Form::hidden('payment_amount', $payment->totalAndLate()) }}
        {{ Form::label("receipt_id", trans('installments.receipt_id')) }} <span class="required">*</span>
        {{ Form::text('receipt_id', null, [
            'class'    =>  'form-control',
            'id'       =>  'receipt_id',
            'placeholder'  =>  trans('installments.receipt_id')
        ]) }}
    </div>
    <div class="col-md-6 form-group">
        {{ Form::label("payment_name", trans('installments.payment_name')) }} <span class="required">*</span>
        {{ Form::text('payment_name', null, [
            'class'    =>  'form-control',
            'placeholder'  =>  trans('installments.payment_name')
        ]) }}
    </div>
</div>
<div class="row">
    <div class="col-md-12 form-group">
        {{ Form::label('payment_date',Trans("installments.date_payment")) }} <span class="required">*</span>
        <?php
        $selected = $type ? $currentDate : null;
        ?>
        <div class="input-group date">
            {{ Form::text('payment_date', $selected, [
                'class' => 'form-control',
                'id' => 'payment_date',
                'placeholder'    =>  trans('installments.date_payment')
            ]) }}
            <div class="input-group-addon">
                <i class="fa fa-calendar-o"></i>
            </div>
        </div>
    </div>
</div>
<div class="row">
    <div class="col-md-6 form-group">
        {{ Form::label("recieve_amount", trans('installments.recieve_amount')) }} <span class="required">*</span>
        {{ Form::number('recieve_amount', $payment->totalAndLate(), [
            'class'    =>  'form-control',
            'placeholder'  =>  trans('installments.recieve_amount'),
        ]) }}
    </div>
    <div class="col-md-6 form-group">
        {{ Form::label("late_amount", trans('installments.late')) }}
        {{ Form::number('late_amount', $payment->lateDay(), [
            'class'    =>  'form-control',
            'placeholder'  =>  trans('installments.late'),
        ]) }}
    </div>
    <div class="col-md-6 form-group">
        {{ Form::label("total_as_letter", trans('installments.total_as_letter')) }}
        {{ Form::text('total_as_letter', null, [
            'class'    =>  'form-control',
            'placeholder'  =>  trans('installments.total_as_letter'),
        ]) }}
    </div>
    <div class="col-md-6 form-group">
        {{ Form::label("in_digit_of", trans('installments.in_digit_of')) }}
        {{ Form::text('in_digit_of', null, [
            'class'    =>  'form-control',
            'placeholder'  =>  trans('installments.in_digit_of')
        ]) }}
    </div>
    <div class="col-md-12 form-group">
        {{ Form::label("with_doc", trans('installments.with_doc')) }}
        {{ Form::textarea('with_doc', null, [
            'class'    =>  'form-control',
            'placeholder'  =>  trans('installments.with_doc'),
            'rows' =>  2
        ]) }}
    </div>
</div>
{{ Form::close() }}