<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="UTF-8">
	<title>EMI Loan Print</title>
    {{ HTML::style('css/installment.css') }}
	{{ HTML::style('css/emi_print.css') }}
</head>
<script>
	window.print();
</script>
<body>
	<div class="container-fluid">
		<div class="row">
			<div class="col-xs-3" >
				{{ HTML::image(get_config('company_logo'), get_config('company_name'), ['width' => '200px;', 'class' => 'logo'])}}
                <h3 class="text-left">{{ trans('installments.menu') }}</h3>
			</div>
			<div class="col-xs-6">
				{{ get_config('company_name') }}
            <p>{{ get_config('company_detail') }}</p>
				<p>{{ get_config('company_address')}}</p>
		</div>
		<div class="row">
			<div class="col-xs-12">
				<hr>
				<table class="table table-nobordered">
					<tr>
						<th style="width: 15%;">{{ trans('installments.code') }}</th>
						<td>{{ convertInvoiceNumber($installment->id) }}</td>
						<th style="width: 15%;">{{ trans('installments.user') }}</th>
						<td style="width: 15%;">{{ $installment->first_name }} {{ $installment->last_name }}</td>
					</tr>
					<tr>
						<th>{{ trans('installments.date_payment') }}</th>
						<td>{{ get_day_week($installment->created_at)}} {{ format_date_installment($installment->created_at) }}</td>
					</tr>
				</table>
			</div>
		</div>
		<div class="row">
			<div class="col-xs-4">
				<table class="table table-bordered">
					<tr>
						<th>{{ trans('installments.customer_name') }}</th>
						<td>{{ $installment->full_name_kh }}</td>
					</tr>
					<tr>
						<th>{{ trans('customers.sex') }}</th>
						<td>{{ trans('customers.gender.'.$installment->gender)}}</td>
					</tr>
					<tr>
						<th>{{ trans('customers.tel') }}</th>
						<td>{{ $installment->tel }}</td>
					</tr>
				</table>
			</div>
			<div class="col-xs-8">
				<table class="table table-bordered">
					<tr>
						<th style="width: 25%;">{{ trans('installments.type_of_product') }}</th>
						<td  style="width: 25%;">{{ $installment->type_of_product }}</td>
						<th style="width: 25%;">{{ trans('installments.product_name') }}</th>
						<td  style="width: 25%;">{{ $installment->product_name }}</td>
					</tr>
					<tr>
						<th style="width: 25%;">{{ trans('installments.model') }}</th>
						<td  style="width: 25%;">{{ $installment->model }}</td>
						<th style="width: 25%;">{{ trans('installments.imie')}}</th>
						<td style="width: 25%;">{{ $installment->imie }}</td>
					</tr>
					<tr>
						<th style="width: 25%;">{{ trans('installments.price') }}</th>
						<td  style="width: 25%;">{{ money($installment->getTotalPrice()) }}</td>
						<th style="width: 25%;">{{ trans('installments.deposit') }}</th>
						<td style="width: 25%;">{{ money($installment->getDeposit()) }}</td>
					</tr>
        		</table>
			</div>
			<div class="col-xs-12">
				<table class="table table-bordered">
					<tr>
						<th>{{ trans('installments.total_principle') }}</th>
						<td>{{ money($installment->getPriciple()) }}</td>
						<th>{{ trans("payments.interest") }}</th>
						<td>{{ $installment->rate }} %</td>
						<th>{{ trans('payments.flat_rate') }}</th>
						<td>{{ $installment->flatRate() }} %</td>
					</tr>
					<tr>
						<th>{{ trans('installments.duration') }}</th>
						<td>{{ $installment->getDuration() }}</td>
						<th>{{ trans("payments.first_month") }}</th>
						<td>{{ money($installment->firstMonth()) }}</td>
						<th>{{ trans("payments.monthly") }}</th>
						<td>{{ money($installment->emiPayment()) }}</td>
					</tr>
					<tr>
						<th>{{ trans("payments.first_date_payment") }}</th>
						<td colspan="2">{{ get_day_week($firstPayDate->payment_date) }} {{ format_date_installment($firstPayDate->payment_date) }}</td>
						<th>{{ trans("payments.last_date_payment") }}</th>
						<td colspan="2">{{ get_day_week($payOffDay->payment_date) }} {{ format_date_installment($payOffDay->payment_date) }}</td>
					</tr>
				</table>
			</div>
		</div>

		<div class="row">
			<div class="col-xs-12">
				<h3>{{ trans("payments.table") }}</h3>
		        <table class="table table-bordered">
                    <thead>
                        <th>{{ trans("installments.id")}}</th>
                        <th colspan="2">{{ trans("installments.payment_date") }}</th>
                        <th>{{ trans("installments.emi") }}</th>
                        <th>{{ trans("installments.interest") }}</th>
                        <th>{{ trans("installments.emi_principal") }}</th>
                        <th>{{ trans("installments.balance") }}</th>
                        <th>{{ trans("installments.debt") }}</th>
                    </thead>
                        <tbody>
                            <?php 
                            $totalPayment = $installment->getTotalPayment();
							$totalInterest = 0;
							$totalPrincipal = 0;
                            ?>
                            @foreach($payments as $payment)
								<?php
								$totalInterest += $payment->interest;
								$totalPrincipal += $payment->principal;
								 ?>
                                <tr>
                                    <td>{{ $payment->term_id }}</td>
									<td>{{ get_day_week($payment->payment_date) }}</td>
                                    <td>{{ $payment->displayDate() }}</td>
                                    <td>{{ money($payment->amount) }}</td>
                                    <td>{{ money($payment->interest) }}</td>
                                    <td>{{ money($payment->principal) }}</td>
                                    <td>{{ money($payment->balance) }}</td>
                                    <td>{{ $payment->term_id == $installment->getDuration() ? 0 : money( $totalPayment-= $payment->amount) }}</td>
                                </tr>
                            @endforeach
                            <tr>
                                <td colspan="3" class="text-right">{{ trans("payments.total")}}</td>
                                <td>{{ money($totalPrincipal + $totalInterest) }}</td>
                                <td>{{ money($totalInterest) }}</td>
                                <td>{{ money($totalPrincipal) }}</td>
                                <td>0</td>
                                <td>0</td>
                            </tr>
                        </tbody>
                    </table>
                <p class="text-left">{{ get_config("invoice_client_note ")}}</p>
			</div>
		</div>
	</div>
</body>
</html>