<?php
$totalI = 0;
$totalP = 0;
$term = 0;
$paidTerm = 0;
foreach ($payments as $payment) {
    $term += $payment->is_paid ? 1 : 0;
    $paidTerm += $payment->is_paid && !$payment->is_paid_all ? 1 : 0;
    $totalI += $payment->is_paid ? $payment->interest : 0;
    $totalP += $payment->is_paid ? $payment->principal : 0;
}
?>
<div class="box box-solid box-default">
    <div class="box-header">
        <h3 class="box-title"><i class="fa fa-credit-card-alt"></i></h3>
    </div>
    <div class="box-body">
        <br>
        <div class="row">
            <div class="col-md-2">
                <!-- small box -->
                <div class="small-box bg-gray">
                    <div class="inner">
                    <h3>{{ $term }}</h3>

                    <p>{{ trans("payments.total_term") }}</p>
                    </div>
                </div>
            </div>
            <div class="col-md-2">
                <!-- small box -->
                <div class="small-box bg-green">
                    <div class="inner">
                    <h3>{{ money($totalI) }}</h3>

                    <p>{{ trans("payments.total_interest") }}</p>
                    </div>
                </div>
            </div>
            <div class="col-md-2">
                <!-- small box -->
                <div class="small-box bg-yellow">
                    <div class="inner">
                    <h3>{{ money($totalP) }}</h3>

                    <p>{{ trans("payments.total_principal") }}</p>
                    </div>
                </div>
            </div>
            <?php 
                $totalPayment = $totalI + $totalP;
            ?>
            <div class="col-md-3">
                <!-- small box -->
                <div class="small-box bg-aqua">
                    <div class="inner">
                    <h3>{{ money($totalPayment) }}</h3>

                    <p>{{ trans("payments.total_received") }}</p>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <!-- small box -->
                <div class="small-box bg-red">
                    <div class="inner">
                    <h3>{{  money($installment->getTotalPayment() - $totalPayment) }}</h3>

                    <p>{{ trans("payments.total_debt") }}</p>
                    </div>
                </div>
            </div>
                        
       </div>
    </div>
</div>