{{ Form::model($payment, ['route' => "installments.returnAll"]) }}
<fieldset>
    <legend>{{ trans('installments.id') }} {{ $payment->term_id }} {{ $payment->displayDate() }} {{ money($totalPayment) }}</legend>
</fieldset>
<div class="row">
    <div class="col-md-6 form-group">
         {{ Form::hidden('payment_id', $payment->id) }}
         {{ Form::hidden('payment_amount', round($totalPayment, 2)) }}
         {{ Form::label("receipt_id", trans('installments.receipt_id')) }} <span class="required">*</span>
         {{ Form::text('receipt_id', null, [
             'class'    =>  'form-control',
             'id'       =>  'receipt_id',
             'placeholder'  =>  trans('installments.receipt_id')
         ]) }}
     </div>
    <div class="col-md-6 form-group"> 
     {{ Form::label("payment_name", trans('installments.payment_name')) }} <span class="required">*</span>
     {{ Form::text('payment_name', null, [
         'class'    =>  'form-control',
         'placeholder'  =>  trans('installments.payment_name')
     ]) }}
    </div> 
</div>
<div class="row">
    <div class="col-md-6 form-group">
         {{ Form::label("recieve_amount", trans('installments.recieve_amount')) }}
         {{ Form::number('recieve_amount', $totalPayment, [
             'class'    =>  'form-control',
             'placeholder'  =>  trans('installments.recieve_amount'),
         ]) }}
     </div>
     <div class="col-md-6 form-group">
         {{ Form::label("late_amount", trans('installments.late')) }}
         {{ Form::number('late_amount', $payment->lateDay(), [
             'class'    =>  'form-control',
             'placeholder'  =>  trans('installments.late'),
         ]) }}
     </div>
     <div class="col-md-12 form-group">
         {{ Form::label("total_as_letter", trans('installments.total_as_letter')) }}
         {{ Form::text('total_as_letter', null, [
             'class'    =>  'form-control',
             'placeholder'  =>  trans('installments.total_as_letter'),
         ]) }}
     </div>
     <div class="col-md-12 form-group">
         {{ Form::label("in_digit_of", trans('installments.in_digit_of')) }}
         {{ Form::textarea('in_digit_of', null, [
             'class'    =>  'form-control',
             'placeholder'  =>  trans('installments.in_digit_of'),
             'rows' =>  2
         ]) }}
     </div>
     <div class="col-md-12 form-group">
         {{ Form::label("with_doc", trans('installments.with_doc')) }}
         {{ Form::text('with_doc', null, [
             'class'    =>  'form-control',
             'placeholder'  =>  trans('installments.with_doc'),
         ]) }}
     </div>
</div>     
{{ Form::close() }}