@extends('layouts.production')
@section('addCss')
<style media="screen">
  #example2_filter input[type=search] {
    width: 200px;
  }
</style>
@endsection
@section('content')
<section class="content-header">
  <h1>
    {{Trans("debts.menu")}}
  </h1>
  <ol class="breadcrumb">
    <li><a href="/"><i class="fa fa-dashboard"></i> Home</a></li>
    <li><a href="{{ Route('debts.index') }}"><i class="fa fa-usd"></i> {{ Trans('debts.menu')}}</a></li>
    <li class="active">{{Trans("dashboard.crud.add")}}</li>
  </ol>
</section>

<!-- Main content -->

<section class="content">
  @include('layouts.includes.message')
  <div class="row">
    <div class="col-md-5">
      <div class="box">
        <div class="box-header with-border">
          <h3 class="box-title">{{ trans('dashboard.others.info') }}</h3>
        </div>
        <div class="box-body">
          <table class="table table-striped">
          <tr>
              <th>{{ trans('suppliers.menu') }}</th>
              <td>{{ $invoice->company_name ? $invoice->company_name : "None" }}</td>
            </tr>
            <tr>
              <th>{{ trans('debts.invoice_no') }}</th>
              <td>{{ $invoice->invoice_no }}</td>
            </tr>
            <tr>
              <th>{{ trans('debts.total') }}</th>
              <td>{{ money($invoice->total) }}</td>
            </tr>
            @if ($invoice->paid > 0)
            <tr>
              <th>{{ trans('debts.paid') }}</th>
              <td>{{ money($invoice->pay) }}</td>
            </tr>
            @endif
            @if ($invoice->payable > 0)
             <tr>
              <th>{{ trans('debts.return_amount') }}</th>
              <td>{{ money($invoice->payable) }}</td>
            </tr>
            @endif
            <tr>
              <th>{{ trans('invoices.status') }}</th>
              <td>{{ get_debt_status($invoice->status) }}</td>
            </tr>
            <tr>
              <th>{{ trans('debts.created_at') }}</th>
              <td>{{ $invoice->created_at }}</td>
            </tr>
          </table>
        </div>
      </div>
    </div>
    <div class="col-md-7">
      <div class="box">
        <div class="box-header with-border">
            <h3 class="box-title">{{ trans('invoices.payment') }}</h3>
        </div>
        <div class="box-body">
        @if ($invoice->payable > 0)
          {{ Form::open(['route' => 'debtReturn', 'class' => 'form-horizontal']) }}
          {{ Form::hidden('invoice_id', $invoice->id) }}
          <div class="form-group">
            <label for="payable" class="col-md-3 control-label">{{ trans('invoices.payable') }}</label>
            <div class="col-md-6">
              {{ Form::number('payable', null, [
                  'class' =>  'form-control',
                  'required'  =>  'required',
                  'step'  =>  'any',
                  'placeholder'   =>  trans('invoices.payable')
              ])}}
            </div>
          </div>
          <div class="form-group">
            <label for="note" class="col-md-3 control-label">{{ trans('invoices.note') }}</label>
            <div class="col-md-6">
                {{ Form::textarea('note', null, [
                    'class' =>    'form-control',
                    'placeholder' =>  trans('invoices.note'),
                    'rows'    =>  '2'
                ])}}
            </div>
          </div>
          <div class="form-group">
              <div class="col-md-offset-3 col-md-6">
                <button type="submit" class="btn btn-success">{{ trans('debts.return_debt') }}</button>
              </div>
          </div>

          {{ Form::close()}}
        @endif
          <table class="table table-striped table-bordered">
            <thead>
              <tr>
                <th style="width:25%">{{ Trans('invoices.created_at') }}</th>
                <th>{{ Trans('invoices.payable_recieved') }}</th>
                <th>{{ Trans('invoices.changed') }}</th>
                <th>{{ Trans('invoices.note') }}</th>
              </tr>
            </thead>
            <tbody>
              @if(count($payables) > 0)
                @foreach($payables as $pa)
                  <tr>
                    <td>{{ $pa->created_at }}</td>
                    <td>{{ money($pa->amount) }}</td>
                    <td>{{ money($pa->changed) }}</td>
                    <td>{{ $pa->note }}</td>
                  </tr>
                @endforeach
            @else
              <tr>
                <td colspan="4" class="text-center">
                  No History
                </td>
              </tr>
            @endif
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
</section>
@endsection
