@extends('layouts.production')
@section('addCss')
<style media="screen">
  #example2_filter input[type=search] {
    width: 200px;
  }
</style>
@endsection
@section('content')
<section class="content-header">
  <h1>
    {{Trans("debts.menu")}}
  </h1>
  <ol class="breadcrumb">
    <li><a href="/"><i class="fa fa-dashboard"></i> Home</a></li>
    <li><a href="{{ Route('debts.index') }}"><i class="fa fa-usd"></i> {{ Trans('debts.menu')}}</a></li>
    <li class="active">{{Trans("dashboard.crud.add")}}</li>
  </ol>
</section>

<!-- Main content -->

<section class="content">
  @include('layouts.includes.message')
  <div class="row">
    <div class="col-md-12">
      <div class="box">
        <div class="box-header with-border">
          <h3 class="box-title">{{ trans('dashboard.others.show_all') }}</h3>
          @if (user_can('create_debt'))
          <a href="{{ route('debts.create') }}" class="btn btn-success pull-right"><i class="fa fa-plus"></i> {{ trans('dashboard.crud.add') }}</a>
          @endif
        </div>
        <div class="box-body">
          <table class="table" id="table-debt">
          </table>
        </div>
      </div>
    </div>
  </div>
</section>
@endsection
@section('addJs')
<script>
    $(function () {
      $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });
      $("#table-debt").DataTable({
        "ajax"        : "{{Route('getDebtList')}}",
        "processing"  : true,
        "serverSide"  : true,
        "paging": true,
        "autoWidth": false,
        "columnDefs": [
          { "searchable": false, "targets":  6}
        ],
        "columns": [
            {data: 'invoice_no', name: 'si.invoice_no', orderable: false, title: '{{ trans('debts.invoice_no') }}'},
            {data: 'company_name', name: 's.company_name',orderable: false,title: '{{ Trans('suppliers.company_name')}}'},
            {data: 'total', name: 'si.total',orderable: false,title: '{{ Trans('invoices.total')}}'},
            {data: 'pay', name: 'si.pay',orderable: false,title: '{{ Trans('debts.paid') }}'},
            {data: 'status', name: 'si.status',orderable: false,title: '{{ Trans('invoices.status') }}'},
            {data: 'created_at', name: 'si.created_at',orderable: false,title: '{{ Trans('debts.created_at') }}'},
            {data: 'action', name: 'action',orderable: false,title: '{{ Trans('dashboard.crud.actions') }}'},

        ],
        initComplete: function () {
          this.api().columns([1,2,3]).every(function () {
              var column = this;
              var input = document.createElement("input");
              $(input).appendTo($(column.footer()).empty())
              .on('change', function () {
                  var val = $.fn.dataTable.util.escapeRegex($(this).val());
                  column.search(val ? val : '', true, false).draw();
              });
          });
        }
      });
    });
  </script>
@endsection
