@extends('layouts.production')
@section('addCss')
<style media="screen">
  #example2_filter input[type=search] {
    width: 200px;
  }
</style>
@endsection
@section('content')
<section class="content-header">
  <h1>
    {{Trans("debts.menu")}}
  </h1>
  <ol class="breadcrumb">
    <li><a href="/"><i class="fa fa-dashboard"></i> Home</a></li>
    <li><a href="{{ Route('debts.index') }}"><i class="fa fa-usd"></i> {{ Trans('debts.menu')}}</a></li>
    <li class="active">{{Trans("dashboard.crud.add")}}</li>
  </ol>
</section>

<!-- Main content -->

<section class="content">
  @include('layouts.includes.message')
  @include('products.quick_forms.modal')
  <div class="row">
    <div class="col-md-12">
      <div class="box">
        <div class="box-header with-border">
          <h3 class="box-title">{{ $debt->exists ?  trans('debts.edit') : trans('debts.create' )}}</h3>
        </div>
        {{ Form::model($debt,[
            'route' => $debt->exists ? ['debts.update', $debt->id] : 'debts.store',
            'method' =>   $debt->exists ? 'PUT' : 'POST'

        ]) }}
        <div class="box-body">
           <div class="row">
                <div class="col-md-4 form-group">
              <?php
              $selected = isset($debt->supplier_id) ? $debt->supplier_id : "none";
               ?>
              {{ Form::label('supplier_id', Trans('products.supplier')) }}
              <div class="input-group">
                {{ Form::select('supplier_id', $suppliers, $selected, ['class' => 'select2 form-control']) }}
                <span class="input-group-btn">
                  <a class="btn btn-default" id="add_item_location" title="Add Item Location" data-toggle="modal" data-target="#supplier-modal"><i class="glyphicon glyphicon-plus"></i></a>
                </span>
              </div>
            </div>
            <div class="col-md-4 form-group">
              {{ Form::label('invoice_no', trans('debts.invoice_no')) }}
              {{ Form::text('invoice_no', null, [
                  'class' => "form-control",
                  'required' => "required",
                  'placeholder' => trans('debts.invoice_no') 
              ]) }}
            </div>
            <div class="col-md-4 form-group">
              {{ Form::label('total', trans('debts.total')) }}
              {{ Form::number('total', null, [
                  'class' => "form-control",
                  'step'  => "any",
                  "required" => "required",
                  'placeholder' => trans('debts.total') 
              ]) }}
            </div>
           </div>
           <div class="row">
              <div class="col-md-4 form-group">
              {{ Form::label('pay', trans('debts.paid')) }}
              {{ Form::number('pay', null, [
                  'class' => "form-control",
                  'step'  => 'any',
                  'placeholder' => trans('debts.paid') 
              ]) }}
            </div>
            <div class="col-md-8 form-group">
              {{ Form::label('comment', trans('debts.note')) }}
              {{ Form::textarea('comment', null, [
                  'class' => "form-control",
                  'rows' => "2",
                  'placeholder' => trans('debts.note') 
              ]) }}
            </div>
           </div>
            <div class="box-footer">
              <button type="submit" class="btn btn-success pull-right">{{ $debt->exists ? trans('dashboard.crud.update') : trans('dashboard.crud.add') }}</button>
              {{ Form::close() }}
            </div>
        </div>
      </div>
    </div>
</section>
@endsection
@section('addJs')
{{ HTML::script('production/js/products.js') }}
@endsection
