@extends('layouts.production')
@section('addCss')
  {{ HTML::style('plugins/morris/morris.css') }}
  <style media="screen">
    .info-box .info-box-content {
      padding-top: 10px;
    }
    .info-box-text, .info-box-number {
      padding: 5px;
    }
  </style>
@endsection
@section('content')
  <section class="content-header">
    <h1>
      {{ Trans('dashboard.home') }}
      <small>{{ Trans('dashboard.sub_title') }}</small>
    </h1>
    <ol class="breadcrumb">
      <li class="active"><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
    </ol>
  </section>

  <!-- Main content -->
  <section class="content">
    @if(Session::has('message'))
      <p class="alert alert-info">
        {{ Session::get('message') }}
      </p>
    @endif
    <div class="row">
      @include('dashboard.inc.info')
    </div>
    <div class="row">
      <div class="col-sm-8">
        @include('dashboard.inc.invoices')

        @include('dashboard.inc.graph')
      </div>
      <div class="col-sm-4">
        @include('dashboard.inc.products')
      </div>
    </div>
  </section>
@endsection
@section('addJs')
 {{-- {{ HTML::script("http://www.chartjs.org/dist/2.7.0/Chart.bundle.js") }} --}}
 {{-- {{ HTML::script("http://www.chartjs.org/samples/latest/utils.js") }} --}}
  <script>
        var MONTHS = ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];
        var config = {
            type: 'line',
            data: {
                labels: <?= json_encode($chartData['month']) ?>,
                datasets: [{
                    label: "Income",
                    backgroundColor: window.chartColors.red,
                    borderColor: window.chartColors.red,
                    data: <?= json_encode($chartData['priciple']) ?>,
                    fill: false,
                }, {
                    label: "Rate",
                    fill: false,
                    backgroundColor: window.chartColors.blue,
                    borderColor: window.chartColors.blue,
                    data: <?= json_encode($chartData["rate"]) ?>,
                }]
            },
            options: {
                responsive: true,
                title:{
                    display:false,
                    text:''
                },
                tooltips: {
                    mode: 'index',
                    intersect: false,
                },
                hover: {
                    mode: 'nearest',
                    intersect: true
                },
                scales: {
                    xAxes: [{
                        display: true,
                        scaleLabel: {
                            display: true,
                            labelString: 'Month'
                        }
                    }],
                    yAxes: [{
                        display: true,
                        scaleLabel: {
                            display: true,
                            labelString: 'Value'
                        }
                    }]
                }
            }
        };

        window.onload = function() {
            var ctx = document.getElementById("canvas").getContext("2d");
            window.myLine = new Chart(ctx, config);
        };
    </script>
 }
@endsection

