<!-- PRODUCT LIST -->
  <div class="box box-primary">
    <div class="box-header with-border">
      <h3 class="box-title">{{ Trans('dashboard.recent_products') }}</h3>

      <div class="box-tools pull-right">
        <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
        </button>
        <button type="button" class="btn btn-box-tool" data-widget="remove"><i class="fa fa-times"></i></button>
      </div>
    </div>
    <!-- /.box-header -->
    <div class="box-body">
      <ul class="products-list product-list-in-box">
        @if($products)
          @foreach($products as $product)
            <li class="item">
              <div class="product-img">
                {{ HTML::image($product->thumbnail, $product->name) }}
              </div>
              <div class="product-info">
                <a href="{{ route('product.show', $product->id) }}" class="product-title">
                  {{ str_limit($product->name,30,'...') }}
                  <span class="label label-info pull-right">{{ money($product->price) }}</span></a>
                    <span class="product-description">
                      {{ str_limit($product->name,30,'...') }}
                    </span>
              </div>
            </li>
          @endforeach
        @endif

      </ul>
    </div>
    <!-- /.box-body -->
    <div class="box-footer text-center">
      <a href="{{ Route('productIndex')}}" class="uppercase">{{ Trans('dashboard.others.show_all') }}</a>
    </div>
    <!-- /.box-footer -->
  </div>
<!-- /.box -->
