<!-- TABLE: LATEST ORDERS -->
  <div class="box box-solid box-primary">
    <div class="box-header with-border">
      <h3 class="box-title"><i class="fa fa-calendar-o"></i> {{ Trans('installments.lates_installment') }}</h3>
    </div>
    <!-- /.box-header -->
    <div class="box-body">
      <div class="table-responsive">
        <table class="table table-striped table-bordered">
              <thead>
                  <tr>
                      <th>{{ trans('installments.id') }}</th>
                      <th>{{ trans("installments.code") }}</th>
                      <th>{{ trans('installments.customer_id') }}</th>
                      <th>{{ trans('installments.date') }}</th>
                      <th>{{ trans('installments.duration')}}</th>
                      <th>{{ trans('installments.price') }}</th>
                  </tr>
              </thead>
              <tbody>
                  @if (count($installments) > 0)
                      <?php
                        $i = 1;
                      ?>
                      @foreach ($installments as $installment)
                          <tr>
                              <td>{{ $i }}</td>
                              <td><a href="{{ $installment->loan_type == 'emi' ? route('emiloans.show', $installment->id) :route('installments.show', $installment->id)}}">{{ convertInvoiceNumber($installment->id) }} @if ($installment->loan_type == "emi") <span class="label label-primary">(EMI)</span> @endif</a></td>
                              <td>{{ $installment->full_name_kh }} <a href="tel:{{ $installment->tel }}"><i class="fa fa-phone"></i> {{ $installment->tel }}</a></td>
                              <td>{{ get_day_week($installment->in_date) }} {{ format_date_installment($installment->in_date)}}</td>
                              <td>{{ $installment->duration }}</td>
                              <td>{{ money($installment->total_price) }}</td>
                          </tr>
                      <?php $i++; ?>
                      @endforeach
                  @else
                      <tr>
                          <td colspan="6">No record....</td>
                      </tr>
                  @endif
              </tbody>
          </table>
      </div>
      <!-- /.table-responsive -->
    </div>
    <!-- /.box-body -->
    <div class="box-footer clearfix">
      <a href="{{ route('installments.index') }}" class="btn btn-sm btn-default btn-flat pull-right"><i class="fa fa-th-list"></i> {{ Trans('dashboard.others.show_all') }}</a>
    </div>
    <!-- /.box-footer -->
  </div>
<!-- /.box -->
